/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.storage.handler.api.ShuffleDeleteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopShuffleDeleteHandler
implements ShuffleDeleteHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopShuffleDeleteHandler.class);
    private Configuration hadoopConf;

    public HadoopShuffleDeleteHandler(Configuration hadoopConf) {
        this.hadoopConf = hadoopConf;
    }

    @Override
    public void delete(String[] storageBasePaths, String appId, String user) {
        for (String deletePath : storageBasePaths) {
            Path path = new Path(deletePath);
            boolean isSuccess = false;
            int times = 0;
            int retryMax = 5;
            long start = System.currentTimeMillis();
            LOG.info("Try delete shuffle data in Hadoop FS for appId[{}] of user[{}] with {}", new Object[]{appId, user, path});
            while (!isSuccess && times < retryMax) {
                try {
                    FileSystem fileSystem = HadoopFilesystemProvider.getFilesystem((String)user, (Path)path, (Configuration)this.hadoopConf);
                    fileSystem.delete(path, true);
                    isSuccess = true;
                }
                catch (Exception e) {
                    LOG.warn("Can't delete shuffle data for appId[" + appId + "] with " + ++times + " times", (Throwable)e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception happened when Thread.sleep", (Throwable)ex);
                    }
                }
            }
            if (isSuccess) {
                LOG.info("Delete shuffle data in Hadoop FS for appId[" + appId + "] with " + path + " successfully in " + (System.currentTimeMillis() - start) + " ms");
                continue;
            }
            LOG.info("Failed to delete shuffle data in Hadoop FS for appId[" + appId + "] with " + path + " in " + (System.currentTimeMillis() - start) + " ms");
        }
    }
}

