/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.uniffle.client.api.CoordinatorClient;
import org.apache.uniffle.client.api.ShuffleServerClient;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.factory.CoordinatorClientFactory;
import org.apache.uniffle.client.factory.ShuffleServerClientFactory;
import org.apache.uniffle.client.request.RssAppHeartBeatRequest;
import org.apache.uniffle.client.request.RssApplicationInfoRequest;
import org.apache.uniffle.client.request.RssFetchClientConfRequest;
import org.apache.uniffle.client.request.RssFetchRemoteStorageRequest;
import org.apache.uniffle.client.request.RssFinishShuffleRequest;
import org.apache.uniffle.client.request.RssGetShuffleAssignmentsRequest;
import org.apache.uniffle.client.request.RssGetShuffleResultForMultiPartRequest;
import org.apache.uniffle.client.request.RssGetShuffleResultRequest;
import org.apache.uniffle.client.request.RssRegisterShuffleRequest;
import org.apache.uniffle.client.request.RssReportShuffleResultRequest;
import org.apache.uniffle.client.request.RssSendCommitRequest;
import org.apache.uniffle.client.request.RssSendShuffleDataRequest;
import org.apache.uniffle.client.request.RssUnregisterShuffleRequest;
import org.apache.uniffle.client.response.ClientResponse;
import org.apache.uniffle.client.response.RssAppHeartBeatResponse;
import org.apache.uniffle.client.response.RssApplicationInfoResponse;
import org.apache.uniffle.client.response.RssFetchClientConfResponse;
import org.apache.uniffle.client.response.RssFetchRemoteStorageResponse;
import org.apache.uniffle.client.response.RssFinishShuffleResponse;
import org.apache.uniffle.client.response.RssGetShuffleAssignmentsResponse;
import org.apache.uniffle.client.response.RssGetShuffleResultResponse;
import org.apache.uniffle.client.response.RssRegisterShuffleResponse;
import org.apache.uniffle.client.response.RssReportShuffleResultResponse;
import org.apache.uniffle.client.response.RssSendCommitResponse;
import org.apache.uniffle.client.response.RssSendShuffleDataResponse;
import org.apache.uniffle.client.response.RssUnregisterShuffleResponse;
import org.apache.uniffle.client.response.SendShuffleDataResult;
import org.apache.uniffle.client.util.ClientUtils;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.com.google.common.collect.Lists;
import org.apache.uniffle.com.google.common.collect.Maps;
import org.apache.uniffle.com.google.common.collect.Sets;
import org.apache.uniffle.common.ClientType;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleAssignmentsInfo;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleWriteClientImpl
implements ShuffleWriteClient {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleWriteClientImpl.class);
    private String clientType;
    private int retryMax;
    private long retryIntervalMax;
    private List<CoordinatorClient> coordinatorClients = Lists.newLinkedList();
    private Map<String, Map<Integer, Set<ShuffleServerInfo>>> shuffleServerInfoMap = JavaUtils.newConcurrentMap();
    private CoordinatorClientFactory coordinatorClientFactory;
    private ExecutorService heartBeatExecutorService;
    private int replica;
    private int replicaWrite;
    private int replicaRead;
    private boolean replicaSkipEnabled;
    private int dataCommitPoolSize = -1;
    private final ExecutorService dataTransferPool;
    private final int unregisterThreadPoolSize;
    private final int unregisterRequestTimeSec;
    private Set<ShuffleServerInfo> defectiveServers;
    private RssConf rssConf;

    public ShuffleWriteClientImpl(String clientType, int retryMax, long retryIntervalMax, int heartBeatThreadNum, int replica, int replicaWrite, int replicaRead, boolean replicaSkipEnabled, int dataTransferPoolSize, int dataCommitPoolSize, int unregisterThreadPoolSize, int unregisterRequestTimeSec) {
        this(clientType, retryMax, retryIntervalMax, heartBeatThreadNum, replica, replicaWrite, replicaRead, replicaSkipEnabled, dataTransferPoolSize, dataCommitPoolSize, unregisterThreadPoolSize, unregisterRequestTimeSec, new RssConf());
    }

    public ShuffleWriteClientImpl(String clientType, int retryMax, long retryIntervalMax, int heartBeatThreadNum, int replica, int replicaWrite, int replicaRead, boolean replicaSkipEnabled, int dataTransferPoolSize, int dataCommitPoolSize, int unregisterThreadPoolSize, int unregisterRequestTimeSec, RssConf rssConf) {
        this.clientType = clientType;
        this.retryMax = retryMax;
        this.retryIntervalMax = retryIntervalMax;
        this.coordinatorClientFactory = new CoordinatorClientFactory(ClientType.valueOf(clientType));
        this.heartBeatExecutorService = ThreadUtils.getDaemonFixedThreadPool(heartBeatThreadNum, "client-heartbeat");
        this.replica = replica;
        this.replicaWrite = replicaWrite;
        this.replicaRead = replicaRead;
        this.replicaSkipEnabled = replicaSkipEnabled;
        this.dataTransferPool = Executors.newFixedThreadPool(dataTransferPoolSize);
        this.dataCommitPoolSize = dataCommitPoolSize;
        this.unregisterThreadPoolSize = unregisterThreadPoolSize;
        this.unregisterRequestTimeSec = unregisterRequestTimeSec;
        if (replica > 1) {
            this.defectiveServers = Sets.newConcurrentHashSet();
        }
        this.rssConf = rssConf;
    }

    private boolean sendShuffleDataAsync(String appId, Map<ShuffleServerInfo, Map<Integer, Map<Integer, List<ShuffleBlockInfo>>>> serverToBlocks, Map<ShuffleServerInfo, List<Long>> serverToBlockIds, Map<Long, AtomicInteger> blockIdsTracker, boolean allowFastFail, Supplier<Boolean> needCancelRequest) {
        if (serverToBlockIds == null) {
            return true;
        }
        ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
        for (Map.Entry<ShuffleServerInfo, Map<Integer, Map<Integer, List<ShuffleBlockInfo>>>> entry : serverToBlocks.entrySet()) {
            CompletableFuture<Boolean> future = CompletableFuture.supplyAsync(() -> {
                if (((Boolean)needCancelRequest.get()).booleanValue()) {
                    LOG.info("The upstream task has been failed. Abort this data send.");
                    return true;
                }
                ShuffleServerInfo ssi = (ShuffleServerInfo)entry.getKey();
                try {
                    Map shuffleIdToBlocks = (Map)entry.getValue();
                    RssSendShuffleDataRequest request = new RssSendShuffleDataRequest(appId, this.retryMax, this.retryIntervalMax, shuffleIdToBlocks);
                    long s = System.currentTimeMillis();
                    RssSendShuffleDataResponse response = this.getShuffleServerClient(ssi).sendShuffleData(request);
                    String logMsg = String.format("ShuffleWriteClientImpl sendShuffleData with %s blocks to %s cost: %s(ms)", ((List)serverToBlockIds.get(ssi)).size(), ssi.getId(), System.currentTimeMillis() - s);
                    if (response.getStatusCode() == StatusCode.SUCCESS) {
                        ((List)serverToBlockIds.get(ssi)).forEach(block -> ((AtomicInteger)blockIdsTracker.get(block)).incrementAndGet());
                        if (this.defectiveServers != null) {
                            this.defectiveServers.remove(ssi);
                        }
                    } else {
                        if (this.defectiveServers != null) {
                            this.defectiveServers.add(ssi);
                        }
                        LOG.warn("{}, it failed wth statusCode[{}]", (Object)logMsg, (Object)response.getStatusCode());
                        return false;
                    }
                    LOG.debug("{} successfully.", (Object)logMsg);
                }
                catch (Exception e) {
                    if (this.defectiveServers != null) {
                        this.defectiveServers.add(ssi);
                    }
                    LOG.warn("Send: " + ((List)serverToBlockIds.get(ssi)).size() + " blocks to [" + ssi.getId() + "] failed.", (Throwable)e);
                    return false;
                }
                return true;
            }, this.dataTransferPool);
            futures.add(future);
        }
        boolean result = ClientUtils.waitUntilDoneOrFail(futures, allowFastFail);
        if (!result) {
            LOG.error("Some shuffle data can't be sent to shuffle-server, is fast fail: {}, cancelled task size: {}", (Object)allowFastFail, (Object)futures.size());
        }
        return result;
    }

    void genServerToBlocks(ShuffleBlockInfo sbi, List<ShuffleServerInfo> serverList, int replicaNum, Collection<ShuffleServerInfo> excludeServers, Map<ShuffleServerInfo, Map<Integer, Map<Integer, List<ShuffleBlockInfo>>>> serverToBlocks, Map<ShuffleServerInfo, List<Long>> serverToBlockIds, boolean excludeDefectiveServers) {
        if (replicaNum <= 0) {
            return;
        }
        Stream<Object> servers = excludeDefectiveServers && CollectionUtils.isNotEmpty(this.defectiveServers) ? Stream.concat(serverList.stream().filter(x -> !this.defectiveServers.contains(x)), serverList.stream().filter(this.defectiveServers::contains)) : serverList.stream();
        if (excludeServers != null) {
            servers = servers.filter(x -> !excludeServers.contains(x));
        }
        Stream<Object> selected = servers.limit(replicaNum);
        if (excludeServers != null) {
            selected = selected.peek(excludeServers::add);
        }
        selected.forEach(ssi -> {
            serverToBlockIds.computeIfAbsent((ShuffleServerInfo)ssi, id -> Lists.newArrayList()).add(sbi.getBlockId());
            serverToBlocks.computeIfAbsent((ShuffleServerInfo)ssi, id -> Maps.newHashMap()).computeIfAbsent(sbi.getShuffleId(), id -> Maps.newHashMap()).computeIfAbsent(sbi.getPartitionId(), id -> Lists.newArrayList()).add(sbi);
        });
    }

    @Override
    public SendShuffleDataResult sendShuffleData(String appId, List<ShuffleBlockInfo> shuffleBlockInfoList, Supplier<Boolean> needCancelRequest) {
        HashMap<ShuffleServerInfo, Map<Integer, Map<Integer, List<ShuffleBlockInfo>>>> primaryServerToBlocks = Maps.newHashMap();
        HashMap<ShuffleServerInfo, Map<Integer, Map<Integer, List<ShuffleBlockInfo>>>> secondaryServerToBlocks = Maps.newHashMap();
        HashMap<ShuffleServerInfo, List<Long>> primaryServerToBlockIds = Maps.newHashMap();
        HashMap<ShuffleServerInfo, List<Long>> secondaryServerToBlockIds = Maps.newHashMap();
        for (ShuffleBlockInfo sbi : shuffleBlockInfoList) {
            List<ShuffleServerInfo> allServers = sbi.getShuffleServerInfos();
            if (this.replicaSkipEnabled) {
                HashSet<ShuffleServerInfo> excludeServers = Sets.newHashSet();
                this.genServerToBlocks(sbi, allServers, this.replicaWrite, excludeServers, primaryServerToBlocks, primaryServerToBlockIds, true);
                this.genServerToBlocks(sbi, allServers, this.replica - this.replicaWrite, excludeServers, secondaryServerToBlocks, secondaryServerToBlockIds, false);
                continue;
            }
            this.genServerToBlocks(sbi, allServers, allServers.size(), null, primaryServerToBlocks, primaryServerToBlockIds, false);
        }
        HashMap<Long, AtomicInteger> blockIdsTracker = Maps.newHashMap();
        primaryServerToBlockIds.values().forEach(blockList -> blockList.forEach(block -> blockIdsTracker.put((Long)block, new AtomicInteger(0))));
        secondaryServerToBlockIds.values().forEach(blockList -> blockList.forEach(block -> blockIdsTracker.put((Long)block, new AtomicInteger(0))));
        Set<Long> failedBlockIds = Sets.newConcurrentHashSet();
        Set<Long> successBlockIds = Sets.newConcurrentHashSet();
        boolean isAllSuccess = this.sendShuffleDataAsync(appId, primaryServerToBlocks, primaryServerToBlockIds, blockIdsTracker, secondaryServerToBlocks.isEmpty(), needCancelRequest);
        if (!(isAllSuccess || secondaryServerToBlocks.isEmpty() || needCancelRequest.get().booleanValue())) {
            LOG.info("The sending of primary round is failed partially, so start the secondary round");
            this.sendShuffleDataAsync(appId, secondaryServerToBlocks, secondaryServerToBlockIds, blockIdsTracker, true, needCancelRequest);
        }
        blockIdsTracker.entrySet().forEach(blockCt -> {
            long blockId = (Long)blockCt.getKey();
            int count = ((AtomicInteger)blockCt.getValue()).get();
            if (count >= this.replicaWrite) {
                successBlockIds.add(blockId);
            } else {
                failedBlockIds.add(blockId);
            }
        });
        return new SendShuffleDataResult(successBlockIds, failedBlockIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendCommit(Set<ShuffleServerInfo> shuffleServerInfoSet, String appId, int shuffleId, int numMaps) {
        ForkJoinPool forkJoinPool = new ForkJoinPool(this.dataCommitPoolSize == -1 ? shuffleServerInfoSet.size() : this.dataCommitPoolSize);
        AtomicInteger successfulCommit = new AtomicInteger(0);
        try {
            ((ForkJoinTask)forkJoinPool.submit(() -> shuffleServerInfoSet.parallelStream().forEach(ssi -> {
                RssSendCommitRequest request = new RssSendCommitRequest(appId, shuffleId);
                String errorMsg = "Failed to commit shuffle data to " + ssi + " for shuffleId[" + shuffleId + "]";
                long startTime = System.currentTimeMillis();
                try {
                    RssSendCommitResponse response = this.getShuffleServerClient((ShuffleServerInfo)ssi).sendCommit(request);
                    if (response.getStatusCode() == StatusCode.SUCCESS) {
                        int commitCount = response.getCommitCount();
                        LOG.info("Successfully sendCommit for appId[" + appId + "], shuffleId[" + shuffleId + "] to ShuffleServer[" + ssi.getId() + "], cost " + (System.currentTimeMillis() - startTime) + " ms, got committed maps[" + commitCount + "], map number of stage is " + numMaps);
                        if (commitCount >= numMaps) {
                            RssFinishShuffleResponse rfsResponse = this.getShuffleServerClient((ShuffleServerInfo)ssi).finishShuffle(new RssFinishShuffleRequest(appId, shuffleId));
                            if (rfsResponse.getStatusCode() != StatusCode.SUCCESS) {
                                String msg = "Failed to finish shuffle to " + ssi + " for shuffleId[" + shuffleId + "] with statusCode " + (Object)((Object)rfsResponse.getStatusCode());
                                LOG.error(msg);
                                throw new Exception(msg);
                            }
                            LOG.info("Successfully finish shuffle to " + ssi + " for shuffleId[" + shuffleId + "]");
                        }
                    } else {
                        String msg = errorMsg + " with statusCode " + (Object)((Object)response.getStatusCode());
                        LOG.error(msg);
                        throw new Exception(msg);
                    }
                    successfulCommit.incrementAndGet();
                }
                catch (Exception e) {
                    LOG.error(errorMsg, (Throwable)e);
                }
            }))).join();
        }
        finally {
            forkJoinPool.shutdownNow();
        }
        return successfulCommit.get() == shuffleServerInfoSet.size();
    }

    @Override
    public void registerShuffle(ShuffleServerInfo shuffleServerInfo, String appId, int shuffleId, List<PartitionRange> partitionRanges, RemoteStorageInfo remoteStorage, ShuffleDataDistributionType dataDistributionType, int maxConcurrencyPerPartitionToWrite) {
        String user = null;
        try {
            user = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (Exception e) {
            LOG.error("Error on getting user from ugi.", (Throwable)e);
        }
        RssRegisterShuffleRequest request = new RssRegisterShuffleRequest(appId, shuffleId, partitionRanges, remoteStorage, user, dataDistributionType, maxConcurrencyPerPartitionToWrite);
        RssRegisterShuffleResponse response = this.getShuffleServerClient(shuffleServerInfo).registerShuffle(request);
        String msg = "Error happened when registerShuffle with appId[" + appId + "], shuffleId[" + shuffleId + "], " + shuffleServerInfo;
        this.throwExceptionIfNecessary(response, msg);
        this.addShuffleServer(appId, shuffleId, shuffleServerInfo);
    }

    @Override
    public void registerCoordinators(String coordinators) {
        List<CoordinatorClient> clients = this.coordinatorClientFactory.createCoordinatorClient(coordinators);
        this.coordinatorClients.addAll(clients);
    }

    @Override
    public Map<String, String> fetchClientConf(int timeoutMs) {
        RssFetchClientConfResponse response = new RssFetchClientConfResponse(StatusCode.INTERNAL_ERROR, "Empty coordinator clients");
        for (CoordinatorClient coordinatorClient : this.coordinatorClients) {
            response = coordinatorClient.fetchClientConf(new RssFetchClientConfRequest(timeoutMs));
            if (response.getStatusCode() == StatusCode.SUCCESS) {
                LOG.info("Success to get conf from {}", (Object)coordinatorClient.getDesc());
                break;
            }
            LOG.warn("Fail to get conf from {}", (Object)coordinatorClient.getDesc());
        }
        return response.getClientConf();
    }

    @Override
    public RemoteStorageInfo fetchRemoteStorage(String appId) {
        RemoteStorageInfo remoteStorage = new RemoteStorageInfo("");
        for (CoordinatorClient coordinatorClient : this.coordinatorClients) {
            RssFetchRemoteStorageResponse response = coordinatorClient.fetchRemoteStorage(new RssFetchRemoteStorageRequest(appId));
            if (response.getStatusCode() == StatusCode.SUCCESS) {
                remoteStorage = response.getRemoteStorageInfo();
                LOG.info("Success to get storage {} from {}", (Object)remoteStorage, (Object)coordinatorClient.getDesc());
                break;
            }
            LOG.warn("Fail to get conf from {}", (Object)coordinatorClient.getDesc());
        }
        return remoteStorage;
    }

    @Override
    public ShuffleAssignmentsInfo getShuffleAssignments(String appId, int shuffleId, int partitionNum, int partitionNumPerRange, Set<String> requiredTags, int assignmentShuffleServerNumber, int estimateTaskConcurrency) {
        RssGetShuffleAssignmentsRequest request = new RssGetShuffleAssignmentsRequest(appId, shuffleId, partitionNum, partitionNumPerRange, this.replica, requiredTags, assignmentShuffleServerNumber, estimateTaskConcurrency);
        RssGetShuffleAssignmentsResponse response = new RssGetShuffleAssignmentsResponse(StatusCode.INTERNAL_ERROR);
        for (CoordinatorClient coordinatorClient : this.coordinatorClients) {
            try {
                response = coordinatorClient.getShuffleAssignments(request);
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
            }
            if (response.getStatusCode() != StatusCode.SUCCESS) continue;
            LOG.info("Success to get shuffle server assignment from {}", (Object)coordinatorClient.getDesc());
            break;
        }
        String msg = "Error happened when getShuffleAssignments with appId[" + appId + "], shuffleId[" + shuffleId + "], numMaps[" + partitionNum + "], partitionNumPerRange[" + partitionNumPerRange + "] to coordinator. Error message: " + response.getMessage();
        this.throwExceptionIfNecessary(response, msg);
        return new ShuffleAssignmentsInfo(response.getPartitionToServers(), response.getServerToPartitionRanges());
    }

    @Override
    public void reportShuffleResult(Map<Integer, List<ShuffleServerInfo>> partitionToServers, String appId, int shuffleId, long taskAttemptId, Map<Integer, List<Long>> partitionToBlockIds, int bitmapNum) {
        HashMap groupedPartitions = Maps.newHashMap();
        HashMap<Integer, Integer> partitionReportTracker = Maps.newHashMap();
        for (Map.Entry<Integer, List<ShuffleServerInfo>> entry : partitionToServers.entrySet()) {
            int partitionIdx = entry.getKey();
            for (ShuffleServerInfo shuffleServerInfo : entry.getValue()) {
                if (!groupedPartitions.containsKey(shuffleServerInfo)) {
                    groupedPartitions.put(shuffleServerInfo, Lists.newArrayList());
                }
                ((List)groupedPartitions.get(shuffleServerInfo)).add(partitionIdx);
            }
            if (!CollectionUtils.isNotEmpty((Collection)partitionToBlockIds.get(partitionIdx))) continue;
            partitionReportTracker.putIfAbsent(partitionIdx, 0);
        }
        for (Map.Entry<Integer, List<ShuffleServerInfo>> entry : groupedPartitions.entrySet()) {
            HashMap<Integer, List<Long>> requestBlockIds = Maps.newHashMap();
            for (Integer n : entry.getValue()) {
                List<Long> blockIds = partitionToBlockIds.get(n);
                if (!CollectionUtils.isNotEmpty(blockIds)) continue;
                requestBlockIds.put(n, blockIds);
            }
            if (requestBlockIds.isEmpty()) continue;
            RssReportShuffleResultRequest request = new RssReportShuffleResultRequest(appId, shuffleId, taskAttemptId, requestBlockIds, bitmapNum);
            ShuffleServerInfo shuffleServerInfo = (ShuffleServerInfo)((Object)entry.getKey());
            try {
                RssReportShuffleResultResponse response = this.getShuffleServerClient(shuffleServerInfo).reportShuffleResult(request);
                if (response.getStatusCode() == StatusCode.SUCCESS) {
                    LOG.info("Report shuffle result to " + shuffleServerInfo + " for appId[" + appId + "], shuffleId[" + shuffleId + "] successfully");
                    for (Integer partitionId : requestBlockIds.keySet()) {
                        partitionReportTracker.put(partitionId, (Integer)partitionReportTracker.get(partitionId) + 1);
                    }
                    continue;
                }
                LOG.warn("Report shuffle result to " + shuffleServerInfo + " for appId[" + appId + "], shuffleId[" + shuffleId + "] failed with " + (Object)((Object)response.getStatusCode()));
            }
            catch (Exception e) {
                LOG.warn("Report shuffle result is failed to " + shuffleServerInfo + " for appId[" + appId + "], shuffleId[" + shuffleId + "]");
            }
        }
        for (Map.Entry<Integer, List<ShuffleServerInfo>> entry : partitionReportTracker.entrySet()) {
            if ((Integer)((Object)entry.getValue()) >= this.replicaWrite) continue;
            throw new RssException("Quorum check of report shuffle result is failed for appId[" + appId + "], shuffleId[" + shuffleId + "]");
        }
    }

    @Override
    public Roaring64NavigableMap getShuffleResult(String clientType, Set<ShuffleServerInfo> shuffleServerInfoSet, String appId, int shuffleId, int partitionId) {
        RssGetShuffleResultRequest request = new RssGetShuffleResultRequest(appId, shuffleId, partitionId);
        boolean isSuccessful = false;
        Roaring64NavigableMap blockIdBitmap = Roaring64NavigableMap.bitmapOf(new long[0]);
        int successCnt = 0;
        for (ShuffleServerInfo ssi : shuffleServerInfoSet) {
            try {
                RssGetShuffleResultResponse response = this.getShuffleServerClient(ssi).getShuffleResult(request);
                if (response.getStatusCode() != StatusCode.SUCCESS) continue;
                Roaring64NavigableMap blockIdBitmapOfServer = response.getBlockIdBitmap();
                blockIdBitmap.or(blockIdBitmapOfServer);
                if (++successCnt < this.replicaRead) continue;
                isSuccessful = true;
                break;
            }
            catch (Exception e) {
                LOG.warn("Get shuffle result is failed from " + ssi + " for appId[" + appId + "], shuffleId[" + shuffleId + "]");
            }
        }
        if (!isSuccessful) {
            throw new RssFetchFailedException("Get shuffle result is failed for appId[" + appId + "], shuffleId[" + shuffleId + "]");
        }
        return blockIdBitmap;
    }

    @Override
    public Roaring64NavigableMap getShuffleResultForMultiPart(String clientType, Map<ShuffleServerInfo, Set<Integer>> serverToPartitions, String appId, int shuffleId, Set<Integer> failedPartitions) {
        HashMap<Integer, Integer> partitionReadSuccess = Maps.newHashMap();
        Roaring64NavigableMap blockIdBitmap = Roaring64NavigableMap.bitmapOf(new long[0]);
        for (Map.Entry<ShuffleServerInfo, Set<Integer>> entry : serverToPartitions.entrySet()) {
            ShuffleServerInfo shuffleServerInfo = entry.getKey();
            HashSet<Integer> requestPartitions = Sets.newHashSet();
            for (Integer partitionId : entry.getValue()) {
                partitionReadSuccess.putIfAbsent(partitionId, 0);
                if ((Integer)partitionReadSuccess.get(partitionId) >= this.replicaRead) continue;
                requestPartitions.add(partitionId);
            }
            RssGetShuffleResultForMultiPartRequest request = new RssGetShuffleResultForMultiPartRequest(appId, shuffleId, requestPartitions);
            try {
                RssGetShuffleResultResponse response = this.getShuffleServerClient(shuffleServerInfo).getShuffleResultForMultiPart(request);
                if (response.getStatusCode() != StatusCode.SUCCESS) continue;
                Roaring64NavigableMap blockIdBitmapOfServer = response.getBlockIdBitmap();
                blockIdBitmap.or(blockIdBitmapOfServer);
                for (Integer partitionId : requestPartitions) {
                    Integer oldVal = (Integer)partitionReadSuccess.get(partitionId);
                    partitionReadSuccess.put(partitionId, oldVal + 1);
                }
            }
            catch (Exception e) {
                failedPartitions.addAll(requestPartitions);
                LOG.warn("Get shuffle result is failed from " + shuffleServerInfo + " for appId[" + appId + "], shuffleId[" + shuffleId + "], requestPartitions" + requestPartitions);
            }
        }
        boolean isSuccessful = partitionReadSuccess.entrySet().stream().allMatch(x -> (Integer)x.getValue() >= this.replicaRead);
        if (!isSuccessful) {
            throw new RssFetchFailedException("Get shuffle result is failed for appId[" + appId + "], shuffleId[" + shuffleId + "]");
        }
        return blockIdBitmap;
    }

    @Override
    public void registerApplicationInfo(String appId, long timeoutMs, String user) {
        RssApplicationInfoRequest request = new RssApplicationInfoRequest(appId, timeoutMs, user);
        ArrayList callableList = Lists.newArrayList();
        this.coordinatorClients.forEach(coordinatorClient -> callableList.add(() -> {
            try {
                RssApplicationInfoResponse response = coordinatorClient.registerApplicationInfo(request);
                if (response.getStatusCode() != StatusCode.SUCCESS) {
                    LOG.error("Failed to send applicationInfo to " + coordinatorClient.getDesc());
                } else {
                    LOG.info("Successfully send applicationInfo to " + coordinatorClient.getDesc());
                }
            }
            catch (Exception e) {
                LOG.warn("Error happened when send applicationInfo to " + coordinatorClient.getDesc(), (Throwable)e);
            }
            return null;
        }));
        try {
            List futures = this.heartBeatExecutorService.invokeAll(callableList, timeoutMs, TimeUnit.MILLISECONDS);
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
        catch (InterruptedException ie) {
            LOG.warn("register application is interrupted", (Throwable)ie);
        }
    }

    @Override
    public void sendAppHeartbeat(String appId, long timeoutMs) {
        RssAppHeartBeatRequest request = new RssAppHeartBeatRequest(appId, timeoutMs);
        ArrayList callableList = Lists.newArrayList();
        Set<ShuffleServerInfo> allShuffleServers = this.getAllShuffleServers(appId);
        allShuffleServers.forEach(shuffleServerInfo -> callableList.add(() -> {
            try {
                ShuffleServerClient client = ShuffleServerClientFactory.getInstance().getShuffleServerClient(this.clientType, (ShuffleServerInfo)shuffleServerInfo, this.rssConf);
                RssAppHeartBeatResponse response = client.sendHeartBeat(request);
                if (response.getStatusCode() != StatusCode.SUCCESS) {
                    LOG.warn("Failed to send heartbeat to " + shuffleServerInfo);
                }
            }
            catch (Exception e) {
                LOG.warn("Error happened when send heartbeat to " + shuffleServerInfo, (Throwable)e);
            }
            return null;
        }));
        this.coordinatorClients.forEach(coordinatorClient -> callableList.add(() -> {
            try {
                RssAppHeartBeatResponse response = coordinatorClient.sendAppHeartBeat(request);
                if (response.getStatusCode() != StatusCode.SUCCESS) {
                    LOG.warn("Failed to send heartbeat to " + coordinatorClient.getDesc());
                } else {
                    LOG.info("Successfully send heartbeat to " + coordinatorClient.getDesc());
                }
            }
            catch (Exception e) {
                LOG.warn("Error happened when send heartbeat to " + coordinatorClient.getDesc(), (Throwable)e);
            }
            return null;
        }));
        try {
            List futures = this.heartBeatExecutorService.invokeAll(callableList, timeoutMs, TimeUnit.MILLISECONDS);
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
        catch (InterruptedException ie) {
            LOG.warn("heartbeat is interrupted", (Throwable)ie);
        }
    }

    @Override
    public void close() {
        this.heartBeatExecutorService.shutdownNow();
        this.coordinatorClients.forEach(CoordinatorClient::close);
        this.dataTransferPool.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterShuffle(String appId, int shuffleId) {
        RssUnregisterShuffleRequest request = new RssUnregisterShuffleRequest(appId, shuffleId);
        ArrayList callableList = Lists.newArrayList();
        Map<Integer, Set<ShuffleServerInfo>> appServerMap = this.shuffleServerInfoMap.get(appId);
        if (appServerMap == null) {
            return;
        }
        Set<ShuffleServerInfo> shuffleServerInfos = appServerMap.get(shuffleId);
        if (shuffleServerInfos == null) {
            return;
        }
        shuffleServerInfos.forEach(shuffleServerInfo -> callableList.add(() -> {
            try {
                ShuffleServerClient client = ShuffleServerClientFactory.getInstance().getShuffleServerClient(this.clientType, (ShuffleServerInfo)shuffleServerInfo, this.rssConf);
                RssUnregisterShuffleResponse response = client.unregisterShuffle(request);
                if (response.getStatusCode() != StatusCode.SUCCESS) {
                    LOG.warn("Failed to unregister shuffle to " + shuffleServerInfo);
                }
            }
            catch (Exception e) {
                LOG.warn("Error happened when unregistering to " + shuffleServerInfo, (Throwable)e);
            }
            return null;
        }));
        ExecutorService executorService = null;
        try {
            executorService = ThreadUtils.getDaemonFixedThreadPool(Math.min(this.unregisterThreadPoolSize, shuffleServerInfos.size()), "unregister-shuffle");
            List futures = executorService.invokeAll(callableList, this.unregisterRequestTimeSec, TimeUnit.SECONDS);
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
        catch (InterruptedException ie) {
            LOG.warn("Unregister shuffle is interrupted", (Throwable)ie);
        }
        finally {
            if (executorService != null) {
                executorService.shutdownNow();
            }
            this.removeShuffleServer(appId, shuffleId);
        }
    }

    @Override
    public void unregisterShuffle(String appId) {
        Map<Integer, Set<ShuffleServerInfo>> appServerMap = this.shuffleServerInfoMap.get(appId);
        if (appServerMap == null) {
            return;
        }
        appServerMap.keySet().forEach(shuffleId -> this.unregisterShuffle(appId, (int)shuffleId));
    }

    private void throwExceptionIfNecessary(ClientResponse response, String errorMsg) {
        if (response != null && response.getStatusCode() != StatusCode.SUCCESS) {
            LOG.error(errorMsg);
            throw new RssException(errorMsg);
        }
    }

    Set<ShuffleServerInfo> getAllShuffleServers(String appId) {
        Map<Integer, Set<ShuffleServerInfo>> appServerMap = this.shuffleServerInfoMap.get(appId);
        if (appServerMap == null) {
            return Collections.emptySet();
        }
        HashSet<ShuffleServerInfo> serverInfos = Sets.newHashSet();
        appServerMap.values().forEach(serverInfos::addAll);
        return serverInfos;
    }

    @VisibleForTesting
    public ShuffleServerClient getShuffleServerClient(ShuffleServerInfo shuffleServerInfo) {
        return ShuffleServerClientFactory.getInstance().getShuffleServerClient(this.clientType, shuffleServerInfo, this.rssConf);
    }

    @VisibleForTesting
    Set<ShuffleServerInfo> getDefectiveServers() {
        return this.defectiveServers;
    }

    void addShuffleServer(String appId, int shuffleId, ShuffleServerInfo serverInfo) {
        Set<ShuffleServerInfo> shuffleServerInfos;
        Map<Integer, Set<ShuffleServerInfo>> appServerMap = this.shuffleServerInfoMap.get(appId);
        if (appServerMap == null) {
            appServerMap = JavaUtils.newConcurrentMap();
            this.shuffleServerInfoMap.put(appId, appServerMap);
        }
        if ((shuffleServerInfos = appServerMap.get(shuffleId)) == null) {
            shuffleServerInfos = Sets.newConcurrentHashSet();
            appServerMap.put(shuffleId, shuffleServerInfos);
        }
        shuffleServerInfos.add(serverInfo);
    }

    @VisibleForTesting
    void removeShuffleServer(String appId, int shuffleId) {
        Map<Integer, Set<ShuffleServerInfo>> appServerMap = this.shuffleServerInfoMap.get(appId);
        if (appServerMap != null) {
            appServerMap.remove(shuffleId);
        }
    }
}

