/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.uniffle.common.ServerStatus;
import org.apache.uniffle.guava.collect.Lists;
import org.apache.uniffle.guava.util.concurrent.Uninterruptibles;
import org.apache.uniffle.server.Checker;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheck.class);
    private AtomicReference<ServerStatus> serverStatus;
    private final long checkIntervalMs;
    private final Thread thread;
    private volatile boolean isStop = false;
    private List<Checker> checkers = Lists.newArrayList();

    public HealthCheck(AtomicReference<ServerStatus> serverStatus, ShuffleServerConf conf, List<Checker> buildInCheckers) {
        this.serverStatus = serverStatus;
        this.checkIntervalMs = conf.getLong(ShuffleServerConf.HEALTH_CHECK_INTERVAL);
        List configuredCheckers = (List)conf.get(ShuffleServerConf.HEALTH_CHECKER_CLASS_NAMES);
        if (CollectionUtils.isEmpty((Collection)configuredCheckers) && buildInCheckers.isEmpty()) {
            throw new IllegalArgumentException("The checkers cannot be empty");
        }
        this.checkers.addAll(buildInCheckers);
        if (CollectionUtils.isNotEmpty((Collection)configuredCheckers)) {
            try {
                for (String name : configuredCheckers) {
                    Class<?> cls = Class.forName(name);
                    Constructor<?> cons = cls.getConstructor(ShuffleServerConf.class);
                    this.checkers.add((Checker)cons.newInstance(new Object[]{conf}));
                }
            }
            catch (Exception e) {
                LOG.error("HealthCheck fail to init checkers", (Throwable)e);
                throw new IllegalArgumentException("The checkers init fail");
            }
        }
        this.thread = new Thread(() -> {
            while (!this.isStop) {
                try {
                    this.check();
                    Uninterruptibles.sleepUninterruptibly(this.checkIntervalMs, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    LOG.error("HealthCheck encounter the exception", (Throwable)e);
                }
            }
        });
        this.thread.setName("HealthCheckService");
        this.thread.setDaemon(true);
    }

    public void check() {
        for (Checker checker : this.checkers) {
            if (checker.checkIsHealthy()) continue;
            this.serverStatus.set(ServerStatus.UNHEALTHY);
            ShuffleServerMetrics.gaugeIsHealthy.set(1.0);
            return;
        }
        ShuffleServerMetrics.gaugeIsHealthy.set(0.0);
        if (this.serverStatus.get() == ServerStatus.UNHEALTHY) {
            this.serverStatus.set(ServerStatus.ACTIVE);
        }
    }

    public ServerStatus getServerStatus() {
        return this.serverStatus.get();
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        this.isStop = true;
    }
}

