/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.executor.ShuffleReadMetrics;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.shuffle.RssShuffleHandle;
import org.apache.spark.shuffle.RssSparkConfig;
import org.apache.spark.shuffle.RssSparkShuffleUtils;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleHandleInfo;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.reader.RssShuffleReader;
import org.apache.spark.shuffle.writer.AddBlockEvent;
import org.apache.spark.shuffle.writer.DataPusher;
import org.apache.spark.shuffle.writer.RssShuffleWriter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.storage.BlockManagerId;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.factory.ShuffleClientFactory;
import org.apache.uniffle.client.util.ClientUtils;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.com.google.common.collect.Maps;
import org.apache.uniffle.com.google.common.collect.Sets;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleAssignmentsInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.common.rpc.GrpcServer;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.RetryUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.apache.uniffle.shuffle.manager.RssShuffleManagerBase;
import org.apache.uniffle.shuffle.manager.ShuffleManagerGrpcService;
import org.apache.uniffle.shuffle.manager.ShuffleManagerServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.collection.Iterator;

public class RssShuffleManager
extends RssShuffleManagerBase {
    private static final Logger LOG = LoggerFactory.getLogger(RssShuffleManager.class);
    private final String clientType;
    private final long heartbeatInterval;
    private final long heartbeatTimeout;
    private AtomicReference<String> id = new AtomicReference();
    private final int dataReplica;
    private final int dataReplicaWrite;
    private final int dataReplicaRead;
    private final boolean dataReplicaSkipEnabled;
    private final int dataTransferPoolSize;
    private final int dataCommitPoolSize;
    private final Map<String, Set<Long>> taskToSuccessBlockIds;
    private final Map<String, Set<Long>> taskToFailedBlockIds;
    private ScheduledExecutorService heartBeatScheduledExecutorService;
    private boolean heartbeatStarted = false;
    private boolean dynamicConfEnabled = false;
    private final ShuffleDataDistributionType dataDistributionType;
    private final int maxConcurrencyPerPartitionToWrite;
    private String user;
    private String uuid;
    private Set<String> failedTaskIds = Sets.newConcurrentHashSet();
    private DataPusher dataPusher;
    private final Map<Integer, Integer> shuffleIdToPartitionNum = Maps.newConcurrentMap();
    private final Map<Integer, Integer> shuffleIdToNumMapTasks = Maps.newConcurrentMap();
    private ShuffleManagerGrpcService service;
    private GrpcServer shuffleManagerServer;
    protected SparkConf sparkConf;
    protected ShuffleWriteClient shuffleWriteClient;

    public RssShuffleManager(SparkConf conf, boolean isDriver) {
        this.sparkConf = conf;
        boolean supportsRelocation = Optional.ofNullable(SparkEnv.get()).map(env -> env.serializer().supportsRelocationOfSerializedObjects()).orElse(true);
        if (!supportsRelocation) {
            LOG.warn("RSSShuffleManager requires a serializer which supports relocations of serialized object. Please set spark.serializer to org.apache.spark.serializer.KryoSerializer instead");
        }
        this.user = this.sparkConf.get("spark.rss.quota.user", "user");
        this.uuid = this.sparkConf.get("spark.rss.quota.uuid", Long.toString(System.currentTimeMillis()));
        this.dataReplica = (Integer)this.sparkConf.get(RssSparkConfig.RSS_DATA_REPLICA);
        this.dataReplicaWrite = (Integer)this.sparkConf.get(RssSparkConfig.RSS_DATA_REPLICA_WRITE);
        this.dataReplicaRead = (Integer)this.sparkConf.get(RssSparkConfig.RSS_DATA_REPLICA_READ);
        this.dataReplicaSkipEnabled = (Boolean)this.sparkConf.get(RssSparkConfig.RSS_DATA_REPLICA_SKIP_ENABLED);
        LOG.info("Check quorum config [" + this.dataReplica + ":" + this.dataReplicaWrite + ":" + this.dataReplicaRead + ":" + this.dataReplicaSkipEnabled + "]");
        RssUtils.checkQuorumSetting(this.dataReplica, this.dataReplicaWrite, this.dataReplicaRead);
        this.heartbeatInterval = (Long)this.sparkConf.get(RssSparkConfig.RSS_HEARTBEAT_INTERVAL);
        this.heartbeatTimeout = this.sparkConf.getLong(RssSparkConfig.RSS_HEARTBEAT_TIMEOUT.key(), this.heartbeatInterval / 2L);
        int retryMax = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_RETRY_MAX);
        this.clientType = (String)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_TYPE);
        this.dynamicConfEnabled = (Boolean)this.sparkConf.get(RssSparkConfig.RSS_DYNAMIC_CLIENT_CONF_ENABLED);
        this.dataDistributionType = RssShuffleManager.getDataDistributionType(this.sparkConf);
        this.maxConcurrencyPerPartitionToWrite = RssSparkConfig.toRssConf(this.sparkConf).get(RssClientConf.MAX_CONCURRENCY_PER_PARTITION_TO_WRITE);
        long retryIntervalMax = (Long)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_RETRY_INTERVAL_MAX);
        int heartBeatThreadNum = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_HEARTBEAT_THREAD_NUM);
        this.dataTransferPoolSize = (Integer)this.sparkConf.get(RssSparkConfig.RSS_DATA_TRANSFER_POOL_SIZE);
        this.dataCommitPoolSize = (Integer)this.sparkConf.get(RssSparkConfig.RSS_DATA_COMMIT_POOL_SIZE);
        int unregisterThreadPoolSize = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_UNREGISTER_THREAD_POOL_SIZE);
        int unregisterRequestTimeoutSec = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_UNREGISTER_REQUEST_TIMEOUT_SEC);
        RssConf rssConf = RssSparkConfig.toRssConf(this.sparkConf);
        this.shuffleWriteClient = ShuffleClientFactory.getInstance().createShuffleWriteClient(this.clientType, retryMax, retryIntervalMax, heartBeatThreadNum, this.dataReplica, this.dataReplicaWrite, this.dataReplicaRead, this.dataReplicaSkipEnabled, this.dataTransferPoolSize, this.dataCommitPoolSize, unregisterThreadPoolSize, unregisterRequestTimeoutSec, rssConf);
        this.registerCoordinator();
        if (isDriver && this.dynamicConfEnabled) {
            Map<String, String> clusterClientConf = this.shuffleWriteClient.fetchClientConf(this.sparkConf.getInt(RssSparkConfig.RSS_ACCESS_TIMEOUT_MS.key(), ((Integer)RssSparkConfig.RSS_ACCESS_TIMEOUT_MS.defaultValue().get()).intValue()));
            RssSparkShuffleUtils.applyDynamicClientConf(this.sparkConf, clusterClientConf);
        }
        RssSparkShuffleUtils.validateRssClientConf(this.sparkConf);
        this.sparkConf.set("spark.shuffle.service.enabled", "false");
        LOG.info("Disable external shuffle service in RssShuffleManager.");
        this.sparkConf.set("spark.sql.adaptive.localShuffleReader.enabled", "false");
        LOG.info("Disable local shuffle reader in RssShuffleManager.");
        this.sparkConf.set("spark.shuffle.reduceLocality.enabled", "false");
        LOG.info("Disable shuffle data locality in RssShuffleManager.");
        this.taskToSuccessBlockIds = JavaUtils.newConcurrentMap();
        this.taskToFailedBlockIds = JavaUtils.newConcurrentMap();
        if (isDriver) {
            this.heartBeatScheduledExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor("rss-heartbeat");
            if (((Boolean)this.sparkConf.get(RssSparkConfig.RSS_RESUBMIT_STAGE)).booleanValue() && RssSparkShuffleUtils.isStageResubmitSupported()) {
                LOG.info("stage resubmit is supported and enabled");
                rssConf.set(RssBaseConf.RPC_SERVER_PORT, 0);
                ShuffleManagerServerFactory factory = new ShuffleManagerServerFactory(this, rssConf);
                this.service = factory.getService();
                this.shuffleManagerServer = factory.getServer(this.service);
                try {
                    this.shuffleManagerServer.start();
                    this.sparkConf.set(RssSparkConfig.RSS_SHUFFLE_MANAGER_GRPC_PORT, (Object)this.shuffleManagerServer.getPort());
                }
                catch (Exception e) {
                    LOG.error("Failed to start shuffle manager server", (Throwable)e);
                    throw new RssException(e);
                }
            }
        }
        LOG.info("Rss data pusher is starting...");
        int poolSize = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_SEND_THREAD_POOL_SIZE);
        int keepAliveTime = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_SEND_THREAD_POOL_KEEPALIVE);
        this.dataPusher = new DataPusher(this.shuffleWriteClient, this.taskToSuccessBlockIds, this.taskToFailedBlockIds, this.failedTaskIds, poolSize, keepAliveTime);
    }

    public CompletableFuture<Long> sendData(AddBlockEvent event) {
        if (this.dataPusher != null && event != null) {
            return this.dataPusher.send(event);
        }
        return new CompletableFuture<Long>();
    }

    @VisibleForTesting
    protected static ShuffleDataDistributionType getDataDistributionType(SparkConf sparkConf) {
        RssConf rssConf = RssSparkConfig.toRssConf(sparkConf);
        if (((Boolean)sparkConf.get(SQLConf.ADAPTIVE_EXECUTION_ENABLED())).booleanValue() && !rssConf.containsKey(RssClientConf.DATA_DISTRIBUTION_TYPE.key())) {
            return ShuffleDataDistributionType.LOCAL_ORDER;
        }
        return rssConf.get(RssClientConf.DATA_DISTRIBUTION_TYPE);
    }

    @VisibleForTesting
    RssShuffleManager(SparkConf conf, boolean isDriver, DataPusher dataPusher, Map<String, Set<Long>> taskToSuccessBlockIds, Map<String, Set<Long>> taskToFailedBlockIds) {
        this.sparkConf = conf;
        this.clientType = (String)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_TYPE);
        this.dataDistributionType = RssSparkConfig.toRssConf(this.sparkConf).get(RssClientConf.DATA_DISTRIBUTION_TYPE);
        this.maxConcurrencyPerPartitionToWrite = RssSparkConfig.toRssConf(this.sparkConf).get(RssClientConf.MAX_CONCURRENCY_PER_PARTITION_TO_WRITE);
        this.heartbeatInterval = (Long)this.sparkConf.get(RssSparkConfig.RSS_HEARTBEAT_INTERVAL);
        this.heartbeatTimeout = this.sparkConf.getLong(RssSparkConfig.RSS_HEARTBEAT_TIMEOUT.key(), this.heartbeatInterval / 2L);
        this.dataReplica = (Integer)this.sparkConf.get(RssSparkConfig.RSS_DATA_REPLICA);
        this.dataReplicaWrite = (Integer)this.sparkConf.get(RssSparkConfig.RSS_DATA_REPLICA_WRITE);
        this.dataReplicaRead = (Integer)this.sparkConf.get(RssSparkConfig.RSS_DATA_REPLICA_READ);
        this.dataReplicaSkipEnabled = (Boolean)this.sparkConf.get(RssSparkConfig.RSS_DATA_REPLICA_SKIP_ENABLED);
        LOG.info("Check quorum config [" + this.dataReplica + ":" + this.dataReplicaWrite + ":" + this.dataReplicaRead + ":" + this.dataReplicaSkipEnabled + "]");
        RssUtils.checkQuorumSetting(this.dataReplica, this.dataReplicaWrite, this.dataReplicaRead);
        int retryMax = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_RETRY_MAX);
        long retryIntervalMax = (Long)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_RETRY_INTERVAL_MAX);
        int heartBeatThreadNum = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_HEARTBEAT_THREAD_NUM);
        this.dataTransferPoolSize = (Integer)this.sparkConf.get(RssSparkConfig.RSS_DATA_TRANSFER_POOL_SIZE);
        this.dataCommitPoolSize = (Integer)this.sparkConf.get(RssSparkConfig.RSS_DATA_COMMIT_POOL_SIZE);
        int unregisterThreadPoolSize = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_UNREGISTER_THREAD_POOL_SIZE);
        int unregisterRequestTimeoutSec = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_UNREGISTER_REQUEST_TIMEOUT_SEC);
        this.shuffleWriteClient = ShuffleClientFactory.getInstance().createShuffleWriteClient(this.clientType, retryMax, retryIntervalMax, heartBeatThreadNum, this.dataReplica, this.dataReplicaWrite, this.dataReplicaRead, this.dataReplicaSkipEnabled, this.dataTransferPoolSize, this.dataCommitPoolSize, unregisterThreadPoolSize, unregisterRequestTimeoutSec, RssSparkConfig.toRssConf(this.sparkConf));
        this.taskToSuccessBlockIds = taskToSuccessBlockIds;
        this.taskToFailedBlockIds = taskToFailedBlockIds;
        this.heartBeatScheduledExecutorService = null;
        this.dataPusher = dataPusher;
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, ShuffleDependency<K, V, C> dependency) {
        Map partitionToServers;
        if (!SparkEnv.get().serializer().supportsRelocationOfSerializedObjects()) {
            throw new IllegalArgumentException("Can't use serialized shuffle for shuffleId: " + shuffleId + ", because the serializer: " + SparkEnv.get().serializer().getClass().getName() + " does not support object relocation.");
        }
        if (this.id.get() == null) {
            this.id.compareAndSet(null, SparkEnv.get().conf().getAppId() + "_" + this.uuid);
            this.dataPusher.setRssAppId(this.id.get());
        }
        LOG.info("Generate application id used in rss: " + this.id.get());
        if (dependency.partitioner().numPartitions() == 0) {
            this.shuffleIdToPartitionNum.putIfAbsent(shuffleId, 0);
            this.shuffleIdToNumMapTasks.putIfAbsent(shuffleId, dependency.rdd().partitions().length);
            LOG.info("RegisterShuffle with ShuffleId[" + shuffleId + "], partitionNum is 0, return the empty RssShuffleHandle directly");
            Broadcast<ShuffleHandleInfo> hdlInfoBd = RssSparkShuffleUtils.broadcastShuffleHdlInfo(RssSparkShuffleUtils.getActiveSparkContext(), shuffleId, Collections.emptyMap(), RemoteStorageInfo.EMPTY_REMOTE_STORAGE);
            return new RssShuffleHandle<K, V, C>(shuffleId, this.id.get(), dependency.rdd().getNumPartitions(), dependency, hdlInfoBd);
        }
        String storageType = this.sparkConf.get(RssSparkConfig.RSS_STORAGE_TYPE.key());
        RemoteStorageInfo defaultRemoteStorage = new RemoteStorageInfo(this.sparkConf.get(RssSparkConfig.RSS_REMOTE_STORAGE_PATH.key(), ""));
        RemoteStorageInfo remoteStorage = ClientUtils.fetchRemoteStorage(this.id.get(), defaultRemoteStorage, this.dynamicConfEnabled, storageType, this.shuffleWriteClient);
        Set<String> assignmentTags = RssSparkShuffleUtils.getAssignmentTags(this.sparkConf);
        ClientUtils.validateClientType(this.clientType);
        assignmentTags.add(this.clientType);
        int requiredShuffleServerNumber = RssSparkShuffleUtils.getRequiredShuffleServerNumber(this.sparkConf);
        long retryInterval = (Long)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_ASSIGNMENT_RETRY_INTERVAL);
        int retryTimes = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_ASSIGNMENT_RETRY_TIMES);
        int estimateTaskConcurrency = RssSparkShuffleUtils.estimateTaskConcurrency(this.sparkConf);
        try {
            partitionToServers = RetryUtils.retry(() -> {
                ShuffleAssignmentsInfo response = this.shuffleWriteClient.getShuffleAssignments(this.id.get(), shuffleId, dependency.partitioner().numPartitions(), 1, assignmentTags, requiredShuffleServerNumber, estimateTaskConcurrency);
                this.registerShuffleServers(this.id.get(), shuffleId, response.getServerToPartitionRanges(), remoteStorage);
                return response.getPartitionToServers();
            }, retryInterval, retryTimes);
        }
        catch (Throwable throwable) {
            throw new RssException("registerShuffle failed!", throwable);
        }
        this.startHeartbeat();
        this.shuffleIdToPartitionNum.putIfAbsent(shuffleId, dependency.partitioner().numPartitions());
        this.shuffleIdToNumMapTasks.putIfAbsent(shuffleId, dependency.rdd().partitions().length);
        Broadcast<ShuffleHandleInfo> hdlInfoBd = RssSparkShuffleUtils.broadcastShuffleHdlInfo(RssSparkShuffleUtils.getActiveSparkContext(), shuffleId, partitionToServers, remoteStorage);
        LOG.info("RegisterShuffle with ShuffleId[" + shuffleId + "], partitionNum[" + partitionToServers.size() + "], shuffleServerForResult: " + partitionToServers);
        return new RssShuffleHandle<K, V, C>(shuffleId, this.id.get(), dependency.rdd().getNumPartitions(), dependency, hdlInfoBd);
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, long mapId, TaskContext context, ShuffleWriteMetricsReporter metrics) {
        if (!(handle instanceof RssShuffleHandle)) {
            throw new RssException("Unexpected ShuffleHandle:" + handle.getClass().getName());
        }
        RssShuffleHandle rssHandle = (RssShuffleHandle)handle;
        this.setPusherAppId(rssHandle);
        int shuffleId = rssHandle.getShuffleId();
        String taskId = "" + context.taskAttemptId() + "_" + context.attemptNumber();
        ShuffleWriteMetrics writeMetrics = metrics != null ? new WriteMetrics(metrics) : context.taskMetrics().shuffleWriteMetrics();
        LOG.info("RssHandle appId {} shuffleId {} ", (Object)rssHandle.getAppId(), (Object)rssHandle.getShuffleId());
        return new RssShuffleWriter(rssHandle.getAppId(), shuffleId, taskId, context.taskAttemptId(), writeMetrics, this, this.sparkConf, this.shuffleWriteClient, rssHandle, this::markFailedTask, context);
    }

    public void setPusherAppId(RssShuffleHandle rssShuffleHandle) {
        if (this.id.get() == null) {
            this.id.compareAndSet(null, rssShuffleHandle.getAppId());
            this.dataPusher.setRssAppId(this.id.get());
        }
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        return this.getReader(handle, 0, Integer.MAX_VALUE, startPartition, endPartition, context, metrics);
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        long start = System.currentTimeMillis();
        Roaring64NavigableMap taskIdBitmap = this.getExpectedTasksByExecutorId(handle.shuffleId(), startPartition, endPartition, startMapIndex, endMapIndex);
        LOG.info("Get taskId cost " + (System.currentTimeMillis() - start) + " ms, and request expected blockIds from " + taskIdBitmap.getLongCardinality() + " tasks for shuffleId[" + handle.shuffleId() + "], partitionId[" + startPartition + ", " + endPartition + "]");
        return this.getReaderImpl(handle, startMapIndex, endMapIndex, startPartition, endPartition, context, metrics, taskIdBitmap);
    }

    public <K, C> ShuffleReader<K, C> getReaderForRange(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        long start = System.currentTimeMillis();
        Roaring64NavigableMap taskIdBitmap = this.getExpectedTasksByRange(handle.shuffleId(), startPartition, endPartition, startMapIndex, endMapIndex);
        LOG.info("Get taskId cost " + (System.currentTimeMillis() - start) + " ms, and request expected blockIds from " + taskIdBitmap.getLongCardinality() + " tasks for shuffleId[" + handle.shuffleId() + "], partitionId[" + startPartition + ", " + endPartition + "]");
        return this.getReaderImpl(handle, startMapIndex, endMapIndex, startPartition, endPartition, context, metrics, taskIdBitmap);
    }

    public <K, C> ShuffleReader<K, C> getReaderImpl(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics, Roaring64NavigableMap taskIdBitmap) {
        if (!(handle instanceof RssShuffleHandle)) {
            throw new RssException("Unexpected ShuffleHandle:" + handle.getClass().getName());
        }
        RssShuffleHandle rssShuffleHandle = (RssShuffleHandle)handle;
        int partitionNum = rssShuffleHandle.getDependency().partitioner().numPartitions();
        int shuffleId = rssShuffleHandle.getShuffleId();
        Map<Integer, List<ShuffleServerInfo>> allPartitionToServers = rssShuffleHandle.getPartitionToServers();
        Map<Integer, List<ShuffleServerInfo>> requirePartitionToServers = allPartitionToServers.entrySet().stream().filter(x -> (Integer)x.getKey() >= startPartition && (Integer)x.getKey() < endPartition).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<ShuffleServerInfo, Set<Integer>> serverToPartitions = RssUtils.generateServerToPartitions(requirePartitionToServers);
        long start = System.currentTimeMillis();
        Roaring64NavigableMap blockIdBitmap = this.getShuffleResultForMultiPart(this.clientType, serverToPartitions, rssShuffleHandle.getAppId(), shuffleId, context.stageAttemptNumber());
        LOG.info("Get shuffle blockId cost " + (System.currentTimeMillis() - start) + " ms, and get " + blockIdBitmap.getLongCardinality() + " blockIds for shuffleId[" + shuffleId + "], startPartition[" + start + "], endPartition[" + endPartition + "]");
        ShuffleReadMetrics readMetrics = metrics != null ? new ReadMetrics(metrics) : context.taskMetrics().shuffleReadMetrics();
        RemoteStorageInfo shuffleRemoteStorageInfo = rssShuffleHandle.getRemoteStorage();
        LOG.info("Shuffle reader using remote storage {}", (Object)shuffleRemoteStorageInfo);
        String shuffleRemoteStoragePath = shuffleRemoteStorageInfo.getPath();
        Configuration readerHadoopConf = RssSparkShuffleUtils.getRemoteStorageHadoopConf(this.sparkConf, shuffleRemoteStorageInfo);
        return new RssShuffleReader(startPartition, endPartition, startMapIndex, endMapIndex, context, rssShuffleHandle, shuffleRemoteStoragePath, readerHadoopConf, partitionNum, RssUtils.generatePartitionToBitmap(blockIdBitmap, startPartition, endPartition), taskIdBitmap, readMetrics, RssSparkConfig.toRssConf(this.sparkConf), this.dataDistributionType);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private Roaring64NavigableMap getExpectedTasksByExecutorId(int shuffleId, int startPartition, int endPartition, int startMapIndex, int endMapIndex) {
        Roaring64NavigableMap taskIdBitmap = Roaring64NavigableMap.bitmapOf(new long[0]);
        Iterator mapStatusIter = null;
        try {
            mapStatusIter = (Iterator)SparkEnv.get().mapOutputTracker().getClass().getDeclaredMethod("getMapSizesByExecutorId", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke((Object)SparkEnv.get().mapOutputTracker(), shuffleId, startMapIndex, endMapIndex, startPartition, endPartition);
        }
        catch (Exception ignored) {
            try {
                mapStatusIter = (Iterator)SparkEnv.get().mapOutputTracker().getClass().getDeclaredMethod("getMapSizesByExecutorId", Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke((Object)SparkEnv.get().mapOutputTracker(), shuffleId, startPartition, endPartition);
            }
            catch (Exception ignored1) {
                try {
                    mapStatusIter = (Iterator)MapOutputTracker.class.getDeclaredMethod("getMapSizesByExecutorId", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke((Object)SparkEnv.get().mapOutputTracker(), shuffleId, startMapIndex, endMapIndex, startPartition, endPartition);
                }
                catch (Exception e) {
                    throw new RssException(e);
                }
            }
        }
        while (mapStatusIter.hasNext()) {
            Tuple2 tuple2 = (Tuple2)mapStatusIter.next();
            if (!((BlockManagerId)tuple2._1()).topologyInfo().isDefined()) {
                throw new RssException("Can't get expected taskAttemptId");
            }
            taskIdBitmap.add(Long.parseLong((String)((BlockManagerId)tuple2._1()).topologyInfo().get()));
        }
        return taskIdBitmap;
    }

    private Roaring64NavigableMap getExpectedTasksByRange(int shuffleId, int startPartition, int endPartition, int startMapIndex, int endMapIndex) {
        Roaring64NavigableMap taskIdBitmap = Roaring64NavigableMap.bitmapOf(new long[0]);
        Iterator mapStatusIter = null;
        try {
            mapStatusIter = (Iterator)SparkEnv.get().mapOutputTracker().getClass().getDeclaredMethod("getMapSizesByRange", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke((Object)SparkEnv.get().mapOutputTracker(), shuffleId, startMapIndex, endMapIndex, startPartition, endPartition);
        }
        catch (Exception e) {
            throw new RssException(e);
        }
        while (mapStatusIter.hasNext()) {
            Tuple2 tuple2 = (Tuple2)mapStatusIter.next();
            if (!((BlockManagerId)tuple2._1()).topologyInfo().isDefined()) {
                throw new RssException("Can't get expected taskAttemptId");
            }
            taskIdBitmap.add(Long.parseLong((String)((BlockManagerId)tuple2._1()).topologyInfo().get()));
        }
        return taskIdBitmap;
    }

    public boolean unregisterShuffle(int shuffleId) {
        try {
            if (SparkEnv.get().executorId().equals("driver")) {
                this.shuffleWriteClient.unregisterShuffle(this.id.get(), shuffleId);
                this.shuffleIdToPartitionNum.remove(shuffleId);
                this.shuffleIdToNumMapTasks.remove(shuffleId);
                if (this.service != null) {
                    this.service.unregisterShuffle(shuffleId);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Errors on unregister to remote shuffle-servers", (Throwable)e);
        }
        return true;
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        throw new RssException("RssShuffleManager.shuffleBlockResolver is not implemented");
    }

    public void stop() {
        if (this.heartBeatScheduledExecutorService != null) {
            this.heartBeatScheduledExecutorService.shutdownNow();
        }
        if (this.shuffleWriteClient != null) {
            this.shuffleWriteClient.unregisterShuffle(this.getAppId());
            this.shuffleWriteClient.close();
        }
        if (this.dataPusher != null) {
            try {
                this.dataPusher.close();
            }
            catch (IOException e) {
                LOG.warn("Errors on closing data pusher", (Throwable)e);
            }
        }
        if (this.shuffleManagerServer != null) {
            try {
                this.shuffleManagerServer.stop();
            }
            catch (InterruptedException e) {
                LOG.info("shuffle manager server is interrupted during stop");
            }
        }
    }

    public void clearTaskMeta(String taskId) {
        this.taskToSuccessBlockIds.remove(taskId);
        this.taskToFailedBlockIds.remove(taskId);
    }

    @VisibleForTesting
    protected void registerShuffleServers(String appId, int shuffleId, Map<ShuffleServerInfo, List<PartitionRange>> serverToPartitionRanges, RemoteStorageInfo remoteStorage) {
        if (serverToPartitionRanges == null || serverToPartitionRanges.isEmpty()) {
            return;
        }
        LOG.info("Start to register shuffleId[" + shuffleId + "]");
        long start = System.currentTimeMillis();
        Set<Map.Entry<ShuffleServerInfo, List<PartitionRange>>> entries = serverToPartitionRanges.entrySet();
        entries.stream().forEach(entry -> this.shuffleWriteClient.registerShuffle((ShuffleServerInfo)entry.getKey(), appId, shuffleId, (List)entry.getValue(), remoteStorage, this.dataDistributionType, this.maxConcurrencyPerPartitionToWrite));
        LOG.info("Finish register shuffleId[" + shuffleId + "] with " + (System.currentTimeMillis() - start) + " ms");
    }

    @VisibleForTesting
    protected void registerCoordinator() {
        String coordinators = this.sparkConf.get(RssSparkConfig.RSS_COORDINATOR_QUORUM.key());
        LOG.info("Start Registering coordinators {}", (Object)coordinators);
        this.shuffleWriteClient.registerCoordinators(coordinators);
    }

    @VisibleForTesting
    public SparkConf getSparkConf() {
        return this.sparkConf;
    }

    private synchronized void startHeartbeat() {
        this.shuffleWriteClient.registerApplicationInfo(this.id.get(), this.heartbeatTimeout, this.user);
        if (!this.heartbeatStarted) {
            this.heartBeatScheduledExecutorService.scheduleAtFixedRate(() -> {
                try {
                    String appId = this.id.get();
                    this.shuffleWriteClient.sendAppHeartbeat(appId, this.heartbeatTimeout);
                    LOG.info("Finish send heartbeat to coordinator and servers");
                }
                catch (Exception e) {
                    LOG.warn("Fail to send heartbeat to coordinator and servers", (Throwable)e);
                }
            }, this.heartbeatInterval / 2L, this.heartbeatInterval, TimeUnit.MILLISECONDS);
            this.heartbeatStarted = true;
        }
    }

    public Set<Long> getFailedBlockIds(String taskId) {
        Set<Long> result = this.taskToFailedBlockIds.get(taskId);
        if (result == null) {
            result = Sets.newHashSet();
        }
        return result;
    }

    public Set<Long> getSuccessBlockIds(String taskId) {
        Set<Long> result = this.taskToSuccessBlockIds.get(taskId);
        if (result == null) {
            result = Sets.newHashSet();
        }
        return result;
    }

    @Override
    public String getAppId() {
        return this.id.get();
    }

    @Override
    public int getMaxFetchFailures() {
        String TASK_MAX_FAILURE = "spark.task.maxFailures";
        return Math.max(1, this.sparkConf.getInt("spark.task.maxFailures", 4) - 1);
    }

    @Override
    public int getPartitionNum(int shuffleId) {
        return this.shuffleIdToPartitionNum.getOrDefault(shuffleId, 0);
    }

    @Override
    public int getNumMaps(int shuffleId) {
        return this.shuffleIdToNumMapTasks.getOrDefault(shuffleId, 0);
    }

    @VisibleForTesting
    public void setAppId(String appId) {
        this.id = new AtomicReference<String>(appId);
    }

    public boolean markFailedTask(String taskId) {
        LOG.info("Mark the task: {} failed.", (Object)taskId);
        this.failedTaskIds.add(taskId);
        return true;
    }

    public boolean isValidTask(String taskId) {
        return !this.failedTaskIds.contains(taskId);
    }

    private Roaring64NavigableMap getShuffleResultForMultiPart(String clientType, Map<ShuffleServerInfo, Set<Integer>> serverToPartitions, String appId, int shuffleId, int stageAttemptId) {
        HashSet<Integer> failedPartitions = Sets.newHashSet();
        try {
            return this.shuffleWriteClient.getShuffleResultForMultiPart(clientType, serverToPartitions, appId, shuffleId, failedPartitions);
        }
        catch (RssFetchFailedException e) {
            throw RssSparkShuffleUtils.reportRssFetchFailedException(e, this.sparkConf, appId, shuffleId, stageAttemptId, failedPartitions);
        }
    }

    public static class WriteMetrics
    extends ShuffleWriteMetrics {
        private ShuffleWriteMetricsReporter reporter;

        public WriteMetrics(ShuffleWriteMetricsReporter reporter) {
            this.reporter = reporter;
        }

        public void incBytesWritten(long v) {
            this.reporter.incBytesWritten(v);
        }

        public void incRecordsWritten(long v) {
            this.reporter.incRecordsWritten(v);
        }

        public void incWriteTime(long v) {
            this.reporter.incWriteTime(v);
        }
    }

    static class ReadMetrics
    extends ShuffleReadMetrics {
        private ShuffleReadMetricsReporter reporter;

        ReadMetrics(ShuffleReadMetricsReporter reporter) {
            this.reporter = reporter;
        }

        public void incRemoteBytesRead(long v) {
            this.reporter.incRemoteBytesRead(v);
        }

        public void incFetchWaitTime(long v) {
            this.reporter.incFetchWaitTime(v);
        }

        public void incRecordsRead(long v) {
            this.reporter.incRecordsRead(v);
        }
    }
}

