/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import java.io.IOException;
import java.util.zip.Checksum;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.apache.tez.runtime.library.common.sort.impl.TezSpillRecord;

public class RssTezPerPartitionRecord
extends TezSpillRecord {
    private int numPartitions;
    private int[] numRecordsPerPartition;

    public RssTezPerPartitionRecord(int numPartitions) {
        super(numPartitions);
        this.numPartitions = numPartitions;
    }

    public RssTezPerPartitionRecord(int numPartitions, int[] numRecordsPerPartition) {
        super(numPartitions);
        this.numPartitions = numPartitions;
        this.numRecordsPerPartition = numRecordsPerPartition;
    }

    public RssTezPerPartitionRecord(Path indexFileName, Configuration job) throws IOException {
        super(indexFileName, job);
    }

    public RssTezPerPartitionRecord(Path indexFileName, Configuration job, String expectedIndexOwner) throws IOException {
        super(indexFileName, job, expectedIndexOwner);
    }

    public RssTezPerPartitionRecord(Path indexFileName, Configuration job, Checksum crc, String expectedIndexOwner) throws IOException {
        super(indexFileName, job, crc, expectedIndexOwner);
    }

    public int size() {
        return this.numPartitions;
    }

    public RssTezIndexRecord getIndex(int i) {
        int records = this.numRecordsPerPartition[i];
        RssTezIndexRecord rssTezIndexRecord = new RssTezIndexRecord();
        rssTezIndexRecord.setData(records != 0);
        return rssTezIndexRecord;
    }

    static class RssTezIndexRecord
    extends TezIndexRecord {
        private boolean hasData;

        RssTezIndexRecord() {
        }

        private void setData(boolean hasData) {
            this.hasData = hasData;
        }

        public boolean hasData() {
            return this.hasData;
        }
    }
}

