/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.guava.collect;

import java.io.Serializable;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.apache.uniffle.guava.annotations.GwtCompatible;
import org.apache.uniffle.guava.annotations.GwtIncompatible;
import org.apache.uniffle.guava.annotations.J2ktIncompatible;
import org.apache.uniffle.guava.base.Preconditions;
import org.apache.uniffle.guava.collect.CollectSpliterators;
import org.apache.uniffle.guava.collect.ElementTypesAreNonnullByDefault;
import org.apache.uniffle.guava.collect.ImmutableAsList;
import org.apache.uniffle.guava.collect.ImmutableCollection;
import org.apache.uniffle.guava.collect.ImmutableList;
import org.apache.uniffle.guava.collect.ImmutableMap;
import org.apache.uniffle.guava.collect.ImmutableSet;
import org.apache.uniffle.guava.collect.Iterators;
import org.apache.uniffle.guava.collect.UnmodifiableIterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class ImmutableMapValues<K, V>
extends ImmutableCollection<V> {
    private final ImmutableMap<K, V> map;

    ImmutableMapValues(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<V> iterator() {
        return new UnmodifiableIterator<V>(){
            final UnmodifiableIterator<Map.Entry<K, V>> entryItr;
            {
                this.entryItr = ((ImmutableSet)ImmutableMapValues.this.map.entrySet()).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryItr.hasNext();
            }

            @Override
            public V next() {
                return ((Map.Entry)this.entryItr.next()).getValue();
            }
        };
    }

    @Override
    public Spliterator<V> spliterator() {
        return CollectSpliterators.map(((ImmutableCollection)((Object)this.map.entrySet())).spliterator(), Map.Entry::getValue);
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        return object != null && Iterators.contains(this.iterator(), object);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    public ImmutableList<V> asList() {
        final ImmutableList entryList = ((ImmutableCollection)((Object)this.map.entrySet())).asList();
        return new ImmutableAsList<V>(){

            @Override
            public V get(int index) {
                return ((Map.Entry)entryList.get(index)).getValue();
            }

            @Override
            ImmutableCollection<V> delegateCollection() {
                return ImmutableMapValues.this;
            }
        };
    }

    @Override
    @GwtIncompatible
    public void forEach(Consumer<? super V> action) {
        Preconditions.checkNotNull(action);
        this.map.forEach((? super K k, ? super V v) -> action.accept((Object)v));
    }

    @GwtIncompatible
    @J2ktIncompatible
    private static class SerializedForm<V>
    implements Serializable {
        final ImmutableMap<?, V> map;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<?, V> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.values();
        }
    }
}

