/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.reader;

import java.io.IOException;
import java.util.Objects;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.shuffle.RssSparkShuffleUtils;
import org.apache.uniffle.client.api.ShuffleManagerClient;
import org.apache.uniffle.client.factory.ShuffleManagerClientFactory;
import org.apache.uniffle.client.request.RssReportShuffleFetchFailureRequest;
import org.apache.uniffle.client.response.RssReportShuffleFetchFailureResponse;
import org.apache.uniffle.common.ClientType;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Product2;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;

public class RssFetchFailedIterator<K, C>
extends AbstractIterator<Product2<K, C>> {
    private static final Logger LOG = LoggerFactory.getLogger(RssFetchFailedIterator.class);
    final Iterator<Product2<K, C>> iter;
    final Builder builder;

    private RssFetchFailedIterator(Builder builder, Iterator<Product2<K, C>> iterator) {
        this.builder = builder;
        this.iter = iterator;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    private static ShuffleManagerClient createShuffleManagerClient(String host, int port) throws IOException {
        ClientType grpc = ClientType.GRPC;
        return ShuffleManagerClientFactory.getInstance().createShuffleManagerClient(grpc, host, port);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RssException generateFetchFailedIfNecessary(RssFetchFailedException e) {
        String driver = this.builder.reportServerHost;
        int port = this.builder.reportServerPort;
        try (ShuffleManagerClient client = RssFetchFailedIterator.createShuffleManagerClient(driver, port);){
            RssReportShuffleFetchFailureRequest req = new RssReportShuffleFetchFailureRequest(this.builder.appId, this.builder.shuffleId, this.builder.stageAttemptId, this.builder.partitionId, e.getMessage());
            RssReportShuffleFetchFailureResponse response = client.reportShuffleFetchFailure(req);
            if (!response.getReSubmitWholeStage()) return e;
            FetchFailedException ffe = RssSparkShuffleUtils.createFetchFailedException(this.builder.shuffleId, -1, this.builder.partitionId, e);
            RssException rssException = new RssException((Throwable)ffe);
            return rssException;
        }
        catch (IOException ioe) {
            LOG.info("Error closing shuffle manager client with error:", (Throwable)ioe);
        }
        return e;
    }

    public boolean hasNext() {
        try {
            return this.iter.hasNext();
        }
        catch (RssFetchFailedException e) {
            throw this.generateFetchFailedIfNecessary(e);
        }
    }

    public Product2<K, C> next() {
        try {
            return (Product2)this.iter.next();
        }
        catch (RssFetchFailedException e) {
            throw this.generateFetchFailedIfNecessary(e);
        }
    }

    public static class Builder {
        private String appId;
        private int shuffleId;
        private int partitionId;
        private int stageAttemptId;
        private String reportServerHost;
        private int reportServerPort;

        private Builder() {
        }

        Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        Builder shuffleId(int shuffleId) {
            this.shuffleId = shuffleId;
            return this;
        }

        Builder partitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        Builder stageAttemptId(int stageAttemptId) {
            this.stageAttemptId = stageAttemptId;
            return this;
        }

        Builder reportServerHost(String host) {
            this.reportServerHost = host;
            return this;
        }

        Builder port(int port) {
            this.reportServerPort = port;
            return this;
        }

        <K, C> RssFetchFailedIterator<K, C> build(Iterator<Product2<K, C>> iter) {
            Objects.requireNonNull(this.appId);
            Objects.requireNonNull(this.reportServerHost);
            return new RssFetchFailedIterator(this, iter);
        }
    }
}

