/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.tez.dag.records.TezTaskAttemptID;

public class GetShuffleServerRequest
implements Writable {
    private TezTaskAttemptID currentTaskAttemptID;
    private int startIndex;
    private int partitionNum;
    private int shuffleId;

    public GetShuffleServerRequest() {
    }

    public GetShuffleServerRequest(TezTaskAttemptID currentTaskAttemptID, int startIndex, int partitionNum, int shuffleId) {
        this.currentTaskAttemptID = currentTaskAttemptID;
        this.startIndex = startIndex;
        this.partitionNum = partitionNum;
        this.shuffleId = shuffleId;
    }

    public void write(DataOutput output) throws IOException {
        output.writeInt(this.startIndex);
        output.writeInt(this.partitionNum);
        output.writeInt(this.shuffleId);
        if (this.currentTaskAttemptID != null) {
            output.writeBoolean(true);
            this.currentTaskAttemptID.write(output);
        } else {
            output.writeBoolean(false);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.startIndex = dataInput.readInt();
        this.partitionNum = dataInput.readInt();
        this.shuffleId = dataInput.readInt();
        boolean hasTaskTaskAttemptID = dataInput.readBoolean();
        if (hasTaskTaskAttemptID) {
            this.currentTaskAttemptID = new TezTaskAttemptID();
            this.currentTaskAttemptID.readFields(dataInput);
        }
    }

    public String toString() {
        return "GetShuffleServerRequest{currentTaskAttemptID=" + this.currentTaskAttemptID + ", startIndex=" + this.startIndex + ", partitionNum=" + this.partitionNum + ", shuffleId=" + this.shuffleId + '}';
    }

    public TezTaskAttemptID getCurrentTaskAttemptID() {
        return this.currentTaskAttemptID;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getPartitionNum() {
        return this.partitionNum;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }
}

