/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.org.roaringbitmap;

import org.apache.uniffle.shaded.org.roaringbitmap.ArrayContainer;
import org.apache.uniffle.shaded.org.roaringbitmap.PeekableCharIterator;
import org.apache.uniffle.shaded.org.roaringbitmap.Util;

final class ReverseArrayContainerCharIterator
implements PeekableCharIterator {
    int pos;
    private ArrayContainer parent;

    ReverseArrayContainerCharIterator() {
    }

    ReverseArrayContainerCharIterator(ArrayContainer p) {
        this.wrap(p);
    }

    @Override
    public void advanceIfNeeded(char maxval) {
        this.pos = Util.reverseUntil(this.parent.content, this.pos + 1, this.parent.cardinality, maxval);
    }

    @Override
    public PeekableCharIterator clone() {
        try {
            return (PeekableCharIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos >= 0;
    }

    @Override
    public char next() {
        return this.parent.content[this.pos--];
    }

    @Override
    public int nextAsInt() {
        return this.parent.content[this.pos--];
    }

    @Override
    public char peekNext() {
        return this.parent.content[this.pos];
    }

    @Override
    public void remove() {
        this.parent.removeAtIndex(this.pos + 1);
        ++this.pos;
    }

    void wrap(ArrayContainer p) {
        this.parent = p;
        this.pos = this.parent.cardinality - 1;
    }
}

