/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.action.osgi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.Registry;

public class RegistryImpl
implements Registry {
    private final Registry parent;
    private final Map<Object, Object> services = new LinkedHashMap<Object, Object>();
    private final Map<String, List<Command>> commands = new HashMap<String, List<Command>>();

    public RegistryImpl(Registry parent) {
        this.parent = parent;
    }

    @Override
    public List<Command> getCommands() {
        return this.getServices(Command.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Command getCommand(String scope, String name) {
        Command command;
        if (this.parent != null && (command = this.parent.getCommand(scope, name)) != null) {
            return command;
        }
        Map<Object, Object> map = this.services;
        synchronized (map) {
            List<Command> cmds = this.commands.get(scope + ":" + name);
            if (cmds != null && !cmds.isEmpty()) {
                return cmds.get(0);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void register(Callable<T> factory, Class<T> clazz) {
        Map<Object, Object> map = this.services;
        synchronized (map) {
            this.services.put(clazz, new Factory<T>(clazz, factory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Object service) {
        Map<Object, Object> map = this.services;
        synchronized (map) {
            this.services.put(service, service);
            if (service instanceof Command) {
                Command cmd = (Command)service;
                String key = cmd.getScope() + ":" + cmd.getName();
                this.commands.computeIfAbsent(key, k -> new ArrayList()).add(cmd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(Object service) {
        Map<Object, Object> map = this.services;
        synchronized (map) {
            Command cmd;
            String key;
            List<Command> cmds;
            this.services.remove(service);
            if (service instanceof Command && (cmds = this.commands.get(key = (cmd = (Command)service).getScope() + ":" + cmd.getName())) != null) {
                cmds.remove(cmd);
                if (cmds.isEmpty()) {
                    this.commands.remove(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getService(Class<T> clazz) {
        Map<Object, Object> map = this.services;
        synchronized (map) {
            for (Object service : this.services.values()) {
                if (service instanceof Factory) {
                    if (!clazz.isAssignableFrom(((Factory)service).clazz) || !this.isVisible(service)) continue;
                    try {
                        Object value = ((Factory)service).callable.call();
                        if (value instanceof List) {
                            Iterator iterator = ((List)value).iterator();
                            if (!iterator.hasNext()) continue;
                            Object v = iterator.next();
                            return clazz.cast(v);
                        }
                        return clazz.cast(value);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!clazz.isInstance(service) || !this.isVisible(service)) continue;
                return clazz.cast(service);
            }
        }
        if (this.parent != null) {
            return this.parent.getService(clazz);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getServices(Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        Map<Object, Object> map = this.services;
        synchronized (map) {
            for (Object service : this.services.values()) {
                if (service instanceof Factory) {
                    if (!clazz.isAssignableFrom(((Factory)service).clazz) || !this.isVisible(service)) continue;
                    try {
                        Object value = ((Factory)service).callable.call();
                        if (value instanceof List) {
                            for (Object v : (List)value) {
                                list.add(clazz.cast(v));
                            }
                            continue;
                        }
                        list.add(clazz.cast(value));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!clazz.isInstance(service) || !this.isVisible(service)) continue;
                list.add(clazz.cast(service));
            }
        }
        if (this.parent != null) {
            list.addAll(this.parent.getServices(clazz));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasService(Class<?> clazz) {
        Map<Object, Object> map = this.services;
        synchronized (map) {
            for (Object service : this.services.values()) {
                if (service instanceof Factory) {
                    if (!clazz.isAssignableFrom(((Factory)service).clazz) || !this.isVisible(service)) continue;
                    return true;
                }
                if (!clazz.isInstance(service) || !this.isVisible(service)) continue;
                return true;
            }
        }
        if (this.parent != null) {
            return this.parent.hasService(clazz);
        }
        return false;
    }

    protected boolean isVisible(Object service) {
        return true;
    }

    static class Factory<T> {
        final Class<T> clazz;
        final Callable<T> callable;

        Factory(Class<T> clazz, Callable<T> callable) {
            this.clazz = clazz;
            this.callable = callable;
        }
    }
}

