/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.support;

import aQute.bnd.maven.support.CachedPom;
import aQute.bnd.maven.support.MavenEntry;
import aQute.bnd.maven.support.Pom;
import aQute.bnd.maven.support.ProjectPom;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;

public class Maven {
    final File userHome = new File(System.getProperty("user.home"));
    final Map<String, MavenEntry> entries = new ConcurrentHashMap<String, MavenEntry>();
    static final String[] ALGORITHMS = new String[]{"md5", "sha1"};
    boolean usecache = false;
    final Executor executor;
    File m2 = new File(this.userHome, ".m2");
    File repository = new File(this.m2, "repository");
    static Pattern MAVEN_RANGE = Pattern.compile("(\\[|\\()(.+)(,(.+))(\\]|\\))");

    public Maven(Executor executor) {
        this.executor = executor == null ? Executors.newCachedThreadPool() : executor;
    }

    public CachedPom getPom(String groupId, String artifactId, String version, URI ... extra) throws Exception {
        MavenEntry entry = this.getEntry(groupId, artifactId, version);
        return entry.getPom(extra);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenEntry getEntry(String groupId, String artifactId, String version) throws Exception {
        MavenEntry entry;
        String path = this.path(groupId, artifactId, version);
        Map<String, MavenEntry> map = this.entries;
        synchronized (map) {
            entry = this.entries.get(path);
            if (entry != null) {
                return entry;
            }
            entry = new MavenEntry(this, path);
            this.entries.put(path, entry);
        }
        return entry;
    }

    private String path(String groupId, String artifactId, String version) {
        return groupId.replace('.', '/') + '/' + artifactId + '/' + version + "/" + artifactId + "-" + version;
    }

    public void schedule(Runnable runnable) {
        if (this.executor == null) {
            runnable.run();
        } else {
            this.executor.execute(runnable);
        }
    }

    public ProjectPom createProjectModel(File file) throws Exception {
        ProjectPom pom = new ProjectPom(this, file);
        pom.parse();
        return pom;
    }

    public MavenEntry getEntry(Pom pom) throws Exception {
        return this.getEntry(pom.getGroupId(), pom.getArtifactId(), pom.getVersion());
    }

    public void setM2(File dir) {
        this.m2 = dir;
        this.repository = new File(dir, "repository");
    }
}

