/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.ContextRequest;
import org.apache.unomi.api.ContextResponse;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.PersonaSession;
import org.apache.unomi.api.PersonaWithSessions;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.PersonalizationService;
import org.apache.unomi.api.services.PrivacyService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.api.services.RulesService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.apache.unomi.rest.service.RestServiceUtils;
import org.apache.unomi.utils.Changes;
import org.apache.unomi.utils.HttpUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Consumes(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/")
@Component(service={ContextJsonEndpoint.class}, property={"osgi.jaxrs.resource=true"})
public class ContextJsonEndpoint {
    private static final Logger logger = LoggerFactory.getLogger((String)ContextJsonEndpoint.class.getName());
    private boolean sanitizeConditions = Boolean.parseBoolean(System.getProperty("org.apache.unomi.security.personalization.sanitizeConditions", "true"));
    @Context
    ServletContext context;
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;
    @Reference
    private ProfileService profileService;
    @Reference
    private PrivacyService privacyService;
    @Reference
    private EventService eventService;
    @Reference
    private RulesService rulesService;
    @Reference
    private PersonalizationService personalizationService;
    @Reference
    private ConfigSharingService configSharingService;
    @Reference
    private RestServiceUtils restServiceUtils;

    @OPTIONS
    @Path(value="/context.js")
    public Response contextJSAsOptions() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).header("Access-Control-Allow-Origin", (Object)"*").build();
    }

    @OPTIONS
    @Path(value="/context.json")
    public Response contextJSONAsOptions() {
        return this.contextJSAsOptions();
    }

    @POST
    @Produces(value={"text/plain"})
    @Path(value="/context.js")
    public Response contextJSAsPost(@Valid ContextRequest contextRequest, @QueryParam(value="personaId") @Pattern(regexp="^(\\w|[-_@]){0,50}$") String personaId, @QueryParam(value="sessionId") @Pattern(regexp="^(\\w|[-_@]){0,50}$") String sessionId, @QueryParam(value="timestamp") Long timestampAsLong, @QueryParam(value="invalidateProfile") boolean invalidateProfile, @QueryParam(value="invalidateSession") boolean invalidateSession) throws JsonProcessingException {
        return this.contextJSAsGet(contextRequest, personaId, sessionId, timestampAsLong, invalidateProfile, invalidateSession);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/context.js")
    public Response contextJSAsGet(@QueryParam(value="payload") @Valid ContextRequest contextRequest, @QueryParam(value="personaId") @Pattern(regexp="^(\\w|[-_@]){0,50}$") String personaId, @QueryParam(value="sessionId") @Pattern(regexp="^(\\w|[-_@]){0,50}$") String sessionId, @QueryParam(value="timestamp") Long timestampAsLong, @QueryParam(value="invalidateProfile") boolean invalidateProfile, @QueryParam(value="invalidateSession") boolean invalidateSession) throws JsonProcessingException {
        ContextResponse contextResponse = this.contextJSONAsPost(contextRequest, personaId, sessionId, timestampAsLong, invalidateProfile, invalidateSession);
        String contextAsJSONString = CustomObjectMapper.getObjectMapper().writeValueAsString((Object)contextResponse);
        StringBuilder responseAsString = new StringBuilder();
        responseAsString.append("window.digitalData = window.digitalData || {};\n").append("var cxs = ").append(contextAsJSONString).append(";\n");
        return Response.ok((Object)responseAsString.toString()).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/context.json")
    public ContextResponse contextJSONAsGet(@QueryParam(value="payload") @Valid ContextRequest contextRequest, @QueryParam(value="personaId") @Pattern(regexp="^(\\w|[-_@]){0,50}$") String personaId, @QueryParam(value="sessionId") @Pattern(regexp="^(\\w|[-_@]){0,50}$") String sessionId, @QueryParam(value="timestamp") Long timestampAsLong, @QueryParam(value="invalidateProfile") boolean invalidateProfile, @QueryParam(value="invalidateSession") boolean invalidateSession) {
        return this.contextJSONAsPost(contextRequest, personaId, sessionId, timestampAsLong, invalidateProfile, invalidateSession);
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/context.json")
    public ContextResponse contextJSONAsPost(@Valid ContextRequest contextRequest, @QueryParam(value="personaId") @Pattern(regexp="^(\\w|[-_@]){0,50}$") String personaId, @QueryParam(value="sessionId") @Pattern(regexp="^(\\w|[-_@]){0,50}$") String sessionId, @QueryParam(value="timestamp") Long timestampAsLong, @QueryParam(value="invalidateProfile") boolean invalidateProfile, @QueryParam(value="invalidateSession") boolean invalidateSession) {
        Changes changesObject;
        Date timestamp = new Date();
        if (timestampAsLong != null) {
            timestamp = new Date(timestampAsLong);
        }
        Persona profile = null;
        PersonaSession session = null;
        String profileId = null;
        if (personaId != null) {
            PersonaWithSessions personaWithSessions = this.profileService.loadPersonaWithSessions(personaId);
            if (personaWithSessions == null) {
                logger.error("Couldn't find persona, please check your personaId parameter");
                profile = null;
            } else {
                profile = personaWithSessions.getPersona();
                session = personaWithSessions.getLastSession();
            }
        }
        String scope = null;
        if (contextRequest != null) {
            if (contextRequest.getSource() != null) {
                scope = contextRequest.getSource().getScope();
            }
            if (contextRequest.getSessionId() != null) {
                sessionId = contextRequest.getSessionId();
            }
            profileId = contextRequest.getProfileId();
        }
        if (profileId == null) {
            profileId = this.restServiceUtils.getProfileIdCookieValue(this.request);
        }
        if (profileId == null && sessionId == null && personaId == null) {
            logger.error("Couldn't find profileId, sessionId or personaId in incoming request! Stopped processing request. See debug level for more information");
            if (logger.isDebugEnabled()) {
                logger.debug("Request dump: {}", (Object)HttpUtils.dumpRequestInfo(this.request));
            }
            throw new BadRequestException("Couldn't find profileId, sessionId or personaId in incoming request!");
        }
        int changes = 0;
        if (profile == null) {
            Persona sessionProfile;
            boolean profileCreated = false;
            if (profileId == null || invalidateProfile) {
                profile = this.createNewProfile(null, timestamp);
                profileCreated = true;
            } else {
                profile = this.profileService.load(profileId);
                if (profile == null) {
                    profile = this.createNewProfile(profileId, timestamp);
                    profileCreated = true;
                } else {
                    changesObject = this.checkMergedProfile((Profile)profile, (Session)session);
                    changes |= changesObject.getChangeType();
                    profile = changesObject.getProfile();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)sessionId) && !invalidateSession && (session = this.profileService.loadSession(sessionId, timestamp)) != null) {
                Boolean requireAnonymousBrowsing;
                sessionProfile = session.getProfile();
                boolean anonymousSessionProfile = sessionProfile.isAnonymousProfile();
                if (!(profile.isAnonymousProfile() || anonymousSessionProfile || profile.getItemId().equals(sessionProfile.getItemId()))) {
                    profile = this.profileService.load(sessionProfile.getItemId());
                }
                if (!(requireAnonymousBrowsing = this.privacyService.isRequireAnonymousBrowsing((Profile)profile)).booleanValue() || !anonymousSessionProfile) {
                    if (requireAnonymousBrowsing.booleanValue() && !anonymousSessionProfile) {
                        sessionProfile = this.privacyService.getAnonymousProfile((Profile)profile);
                        session.setProfile((Profile)sessionProfile);
                        changes |= 2;
                    } else if (!requireAnonymousBrowsing.booleanValue() && anonymousSessionProfile) {
                        sessionProfile = profile;
                        session.setProfile((Profile)sessionProfile);
                        changes |= 2;
                    } else if (!requireAnonymousBrowsing.booleanValue() && !anonymousSessionProfile) {
                        sessionProfile = profile;
                        if (!session.getProfileId().equals(sessionProfile.getItemId())) {
                            changes |= 2;
                        }
                        session.setProfile((Profile)sessionProfile);
                    }
                }
            }
            if (session == null || invalidateSession) {
                Object object = sessionProfile = this.privacyService.isRequireAnonymousBrowsing((Profile)profile) != false ? this.privacyService.getAnonymousProfile((Profile)profile) : profile;
                if (StringUtils.isNotBlank((CharSequence)sessionId)) {
                    session = new Session(sessionId, (Profile)sessionProfile, timestamp, scope);
                    changes |= 2;
                    Event event = new Event("sessionCreated", (Session)session, (Profile)profile, scope, null, (Item)session, timestamp);
                    if (sessionProfile.isAnonymousProfile()) {
                        event.setProfileId(null);
                    }
                    event.getAttributes().put("http_request", this.request);
                    event.getAttributes().put("http_response", this.response);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Received event {} for profile={} session={} target={} timestamp={}", new Object[]{event.getEventType(), profile.getItemId(), session.getItemId(), event.getTarget(), timestamp});
                    }
                    changes |= this.eventService.send(event);
                }
            }
            if (profileCreated) {
                changes |= 4;
                Event profileUpdated = new Event("profileUpdated", (Session)session, (Profile)profile, scope, null, (Item)profile, timestamp);
                profileUpdated.setPersistent(false);
                profileUpdated.getAttributes().put("http_request", this.request);
                profileUpdated.getAttributes().put("http_response", this.response);
                if (logger.isDebugEnabled()) {
                    logger.debug("Received event {} for profile={} {} target={} timestamp={}", new Object[]{profileUpdated.getEventType(), profile.getItemId(), " session=" + (session != null ? session.getItemId() : null), profileUpdated.getTarget(), timestamp});
                }
                changes |= this.eventService.send(profileUpdated);
            }
        }
        ContextResponse contextResponse = new ContextResponse();
        contextResponse.setProfileId(profile.getItemId());
        if (session != null) {
            contextResponse.setSessionId(session.getItemId());
        } else if (sessionId != null) {
            contextResponse.setSessionId(sessionId);
        }
        if (contextRequest != null) {
            changesObject = this.handleRequest(contextRequest, (Session)session, (Profile)profile, contextResponse, (ServletRequest)this.request, (ServletResponse)this.response, timestamp);
            changes |= changesObject.getChangeType();
            profile = changesObject.getProfile();
        }
        if ((changes & 4) == 4) {
            this.profileService.save((Profile)profile);
            contextResponse.setProfileId(profile.getItemId());
        }
        if ((changes & 2) == 2 && session != null) {
            this.profileService.saveSession((Session)session);
            contextResponse.setSessionId(session.getItemId());
        }
        if ((changes & 1) == 1) {
            this.response.setStatus(500);
        }
        if (!(profile instanceof Persona)) {
            this.response.setHeader("Set-Cookie", HttpUtils.getProfileCookieString((Profile)profile, this.configSharingService));
        }
        return contextResponse;
    }

    private Changes checkMergedProfile(Profile profile, Session session) {
        int changes = 0;
        if (profile.getMergedWith() != null && !this.privacyService.isRequireAnonymousBrowsing(profile).booleanValue() && !profile.isAnonymousProfile()) {
            Profile currentProfile = profile;
            String masterProfileId = profile.getMergedWith();
            Profile masterProfile = this.profileService.load(masterProfileId);
            if (masterProfile != null) {
                logger.info("Current profile {} was merged with profile {}, replacing profile in session", (Object)currentProfile.getItemId(), (Object)masterProfileId);
                profile = masterProfile;
                if (session != null) {
                    session.setProfile(profile);
                    changes = 2;
                }
            } else {
                logger.warn("Couldn't find merged profile {}, falling back to profile {}", (Object)masterProfileId, (Object)currentProfile.getItemId());
                profile.setMergedWith(null);
                changes = 4;
            }
        }
        return new Changes(changes, profile);
    }

    private Changes handleRequest(ContextRequest contextRequest, Session session, Profile profile, ContextResponse data, ServletRequest request, ServletResponse response, Date timestamp) {
        List personalizations;
        Changes changes = this.restServiceUtils.handleEvents(contextRequest.getEvents(), session, profile, request, response, timestamp);
        data.setProcessedEvents(changes.getProcessedItems());
        profile = changes.getProfile();
        if (contextRequest.isRequireSegments()) {
            data.setProfileSegments(profile.getSegments());
        }
        if (contextRequest.getRequiredProfileProperties() != null) {
            HashMap profileProperties = new HashMap(profile.getProperties());
            if (!contextRequest.getRequiredProfileProperties().contains("*")) {
                profileProperties.keySet().retainAll(contextRequest.getRequiredProfileProperties());
            }
            data.setProfileProperties(profileProperties);
        }
        if (session != null) {
            data.setSessionId(session.getItemId());
            if (contextRequest.getRequiredSessionProperties() != null) {
                HashMap sessionProperties = new HashMap(session.getProperties());
                if (!contextRequest.getRequiredSessionProperties().contains("*")) {
                    sessionProperties.keySet().retainAll(contextRequest.getRequiredSessionProperties());
                }
                data.setSessionProperties(sessionProperties);
            }
        }
        this.processOverrides(contextRequest, profile, session);
        List filterNodes = contextRequest.getFilters();
        if (filterNodes != null) {
            data.setFilteringResults(new HashMap());
            for (PersonalizationService.PersonalizedContent personalizedContent : this.sanitizePersonalizedContentObjects(filterNodes)) {
                data.getFilteringResults().put(personalizedContent.getId(), this.personalizationService.filter(profile, session, personalizedContent));
            }
        }
        if ((personalizations = contextRequest.getPersonalizations()) != null) {
            data.setPersonalizations(new HashMap());
            for (PersonalizationService.PersonalizationRequest personalization : this.sanitizePersonalizations(personalizations)) {
                data.getPersonalizations().put(personalization.getId(), this.personalizationService.personalizeList(profile, session, personalization));
            }
        }
        if (!(profile instanceof Persona)) {
            data.setTrackedConditions(this.rulesService.getTrackedConditions(contextRequest.getSource()));
        } else {
            data.setTrackedConditions(Collections.emptySet());
        }
        data.setAnonymousBrowsing(this.privacyService.isRequireAnonymousBrowsing(profile).booleanValue());
        data.setConsents(profile.getConsents());
        return changes;
    }

    private void processOverrides(ContextRequest contextRequest, Profile profile, Session session) {
        if (profile instanceof Persona && contextRequest.getProfileOverrides() != null) {
            if (contextRequest.getProfileOverrides().getScores() != null) {
                profile.setScores(contextRequest.getProfileOverrides().getScores());
            }
            if (contextRequest.getProfileOverrides().getSegments() != null) {
                profile.setSegments(contextRequest.getProfileOverrides().getSegments());
            }
            if (contextRequest.getProfileOverrides().getProperties() != null) {
                profile.setProperties(contextRequest.getProfileOverrides().getProperties());
            }
            if (contextRequest.getSessionPropertiesOverrides() != null && session != null) {
                session.setProperties(contextRequest.getSessionPropertiesOverrides());
            }
        }
    }

    private Profile createNewProfile(String existingProfileId, Date timestamp) {
        String profileId = existingProfileId;
        if (profileId == null) {
            profileId = UUID.randomUUID().toString();
        }
        Profile profile = new Profile(profileId);
        profile.setProperty("firstVisit", (Object)timestamp);
        return profile;
    }

    public void destroy() {
        logger.info("Context servlet shutdown.");
    }

    private List<PersonalizationService.PersonalizedContent> sanitizePersonalizedContentObjects(List<PersonalizationService.PersonalizedContent> personalizedContentObjects) {
        if (!this.sanitizeConditions) {
            return personalizedContentObjects;
        }
        ArrayList<PersonalizationService.PersonalizedContent> result = new ArrayList<PersonalizationService.PersonalizedContent>();
        for (PersonalizationService.PersonalizedContent personalizedContentObject : personalizedContentObjects) {
            boolean foundInvalidCondition = false;
            if (personalizedContentObject.getFilters() != null) {
                for (PersonalizationService.Filter filter : personalizedContentObject.getFilters()) {
                    if (this.sanitizeCondition(filter.getCondition()) != null) continue;
                    foundInvalidCondition = true;
                    break;
                }
            }
            if (foundInvalidCondition) continue;
            result.add(personalizedContentObject);
        }
        return result;
    }

    private List<PersonalizationService.PersonalizationRequest> sanitizePersonalizations(List<PersonalizationService.PersonalizationRequest> personalizations) {
        if (!this.sanitizeConditions) {
            return personalizations;
        }
        ArrayList<PersonalizationService.PersonalizationRequest> result = new ArrayList<PersonalizationService.PersonalizationRequest>();
        for (PersonalizationService.PersonalizationRequest personalizationRequest : personalizations) {
            List<PersonalizationService.PersonalizedContent> personalizedContents = this.sanitizePersonalizedContentObjects(personalizationRequest.getContents());
            if (personalizedContents == null || personalizedContents.isEmpty()) continue;
            result.add(personalizationRequest);
        }
        return result;
    }

    private Condition sanitizeCondition(Condition condition) {
        LinkedHashMap newParameterValues = new LinkedHashMap();
        for (Map.Entry parameterEntry : condition.getParameterValues().entrySet()) {
            Object sanitizedValue = this.sanitizeValue(parameterEntry.getValue());
            if (sanitizedValue != null) {
                newParameterValues.put(parameterEntry.getKey(), parameterEntry.getValue());
                continue;
            }
            return null;
        }
        return condition;
    }

    private Object sanitizeValue(Object value) {
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.startsWith("script::") || stringValue.startsWith("parameter::")) {
                logger.warn("Scripting detected in context request, filtering out. See debug level for more information");
                if (logger.isDebugEnabled()) {
                    logger.debug("Scripting detected in context request with value {}, filtering out...", value);
                }
                return null;
            }
            return stringValue;
        }
        if (value instanceof List) {
            List values = (List)value;
            ArrayList<Object> newValues = new ArrayList<Object>();
            for (Object listObject : values) {
                Object newObject = this.sanitizeValue(listObject);
                if (newObject == null) continue;
                newValues.add(newObject);
            }
            return values;
        }
        if (value instanceof Map) {
            LinkedHashMap newMap = new LinkedHashMap();
            ((Map)value).forEach((key, value1) -> {
                Object newObject = this.sanitizeValue(value1);
                if (newObject != null) {
                    newMap.put(key, newObject);
                }
            });
            return newMap;
        }
        if (value instanceof Condition) {
            return this.sanitizeCondition((Condition)value);
        }
        return value;
    }
}

