/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.server.provider;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.apache.unomi.api.ContextRequest;
import org.apache.unomi.api.EventsCollectorRequest;

@Provider
public class RetroCompatibilityParamConverterProvider
implements ParamConverterProvider {
    private final ObjectMapper objectMapper;
    private final List<Class<?>> allowedConversionForTypes = new ArrayList();

    public RetroCompatibilityParamConverterProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.allowedConversionForTypes.add(ContextRequest.class);
        this.allowedConversionForTypes.add(EventsCollectorRequest.class);
    }

    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (this.allowedConversionForTypes.stream().anyMatch(rawType::isAssignableFrom)) {
            return new ParamConverter<T>(){

                public T fromString(String value) {
                    JsonFactory factory = RetroCompatibilityParamConverterProvider.this.objectMapper.getFactory();
                    try {
                        return RetroCompatibilityParamConverterProvider.this.objectMapper.readValue(factory.createParser(value), rawType);
                    }
                    catch (Exception e) {
                        throw new ProcessingException((Throwable)e);
                    }
                }

                public String toString(T value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }
}

