/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.usage;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class NodeUsage
extends BaseNodeResponse
implements ToXContentFragment {
    private long timestamp;
    private long sinceTime;
    private Map<String, Long> restUsage;

    public NodeUsage(StreamInput in) throws IOException {
        super(in);
        this.timestamp = in.readLong();
        this.sinceTime = in.readLong();
        this.restUsage = (Map)in.readGenericValue();
    }

    public NodeUsage(DiscoveryNode node, long timestamp, long sinceTime, Map<String, Long> restUsage) {
        super(node);
        this.timestamp = timestamp;
        this.sinceTime = sinceTime;
        this.restUsage = restUsage;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSinceTime() {
        return this.sinceTime;
    }

    public Map<String, Long> getRestUsage() {
        return this.restUsage;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("since", this.sinceTime);
        if (this.restUsage != null) {
            builder.field("rest_actions");
            builder.map(this.restUsage);
        }
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.timestamp);
        out.writeLong(this.sinceTime);
        out.writeGenericValue(this.restUsage);
    }
}

