/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedWeightedBalancerMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.WeightedLoadBalancer;

@ManagedResource(description="Managed Weighted LoadBalancer")
public class ManagedWeightedLoadBalancer
extends ManagedProcessor
implements ManagedWeightedBalancerMBean {
    private final WeightedLoadBalancer processor;

    public ManagedWeightedLoadBalancer(CamelContext context, WeightedLoadBalancer processor, LoadBalanceDefinition definition) {
        super(context, processor, definition);
        this.processor = processor;
    }

    @Override
    public Integer getSize() {
        return this.processor.getProcessors().size();
    }

    public LoadBalanceDefinition getDefinition() {
        return (LoadBalanceDefinition)super.getDefinition();
    }

    @Override
    public Boolean isRoundRobin() {
        WeightedLoadBalancerDefinition weighted = (WeightedLoadBalancerDefinition)this.getDefinition().getLoadBalancerType();
        if (weighted != null) {
            return weighted.getRoundRobin();
        }
        return null;
    }

    @Override
    public String getDistributionRatio() {
        WeightedLoadBalancerDefinition weighted = (WeightedLoadBalancerDefinition)this.getDefinition().getLoadBalancerType();
        if (weighted != null) {
            return weighted.getDistributionRatio();
        }
        return null;
    }

    @Override
    public String getDistributionRatioDelimiter() {
        WeightedLoadBalancerDefinition weighted = (WeightedLoadBalancerDefinition)this.getDefinition().getLoadBalancerType();
        if (weighted != null) {
            return weighted.getDistributionRatioDelimiter();
        }
        return null;
    }

    @Override
    public String getLastChosenProcessorId() {
        LoadBalanceDefinition def;
        ProcessorDefinition<?> output;
        int idx = this.processor.getLastChosenProcessorIndex();
        if (idx != -1 && (output = (def = this.getDefinition()).getOutputs().get(idx)) != null) {
            return output.getId();
        }
        return null;
    }
}

