/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.persistence;

import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.persistence.ExchangeData;
import org.apache.cxf.management.persistence.ExchangeDataDAO;
import org.apache.cxf.management.persistence.ExchangeDataProperty;

public class FilesystemExchangeDataDAO
implements ExchangeDataDAO {
    private static final Logger LOG = LogUtils.getL7dLogger(FilesystemExchangeDataDAO.class);
    private String directory;
    private String extension = "txt";

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public void save(ExchangeData exchange) throws Exception {
        Path file = null;
        file = this.directory == null ? Files.createTempFile("cxf-management-", "." + this.extension, new FileAttribute[0]) : Files.createTempFile(Paths.get(this.directory, new String[0]), "cxf-management-", "." + this.extension, new FileAttribute[0]);
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("Service : ");
        stringWriter.append(exchange.getServiceName());
        stringWriter.append("\n");
        stringWriter.append("Operation : ");
        stringWriter.append(exchange.getOperation());
        stringWriter.append("\n");
        stringWriter.append("Status : ");
        stringWriter.append(exchange.getStatus());
        stringWriter.append("\n");
        stringWriter.append("URI : ");
        stringWriter.append(exchange.getUri());
        stringWriter.append("\n");
        stringWriter.append("User agent : ");
        stringWriter.append(exchange.getUserAgent());
        stringWriter.append("\n");
        stringWriter.append("Encoding : ");
        stringWriter.append(exchange.getEncoding());
        stringWriter.append("\n");
        stringWriter.append("Date in : ");
        stringWriter.append(exchange.getInDate().toString());
        stringWriter.append("\n");
        stringWriter.append("Date out : ");
        stringWriter.append(exchange.getOutDate().toString());
        stringWriter.append("\n");
        stringWriter.append("Request size : ");
        stringWriter.append(String.valueOf(exchange.getRequestSize()));
        stringWriter.append("\n");
        stringWriter.append("Response size : ");
        stringWriter.append(String.valueOf(exchange.getResponseSize()));
        stringWriter.append("\n");
        stringWriter.append("\n\n\nRequest : \n\n\n");
        stringWriter.append(exchange.getRequest());
        stringWriter.append("\n\n\n\n");
        stringWriter.append("\n\n\nResponse : \n\n\n");
        stringWriter.append(exchange.getResponse());
        stringWriter.append("\n\n\n\n");
        if ("ERROR".equals(exchange.getStatus())) {
            stringWriter.append("\n\n\nExcepttion : ");
            stringWriter.append(exchange.getExceptionType());
            stringWriter.append("\nStackTrace : ");
            stringWriter.append(exchange.getStackTrace());
            stringWriter.append("\n\n\n\n");
        }
        stringWriter.append("\n\nProperties : \n");
        if (exchange.getProperties() != null) {
            for (ExchangeDataProperty exchangeProperty : exchange.getProperties()) {
                stringWriter.append(exchangeProperty.getName());
                stringWriter.append(" : ");
                stringWriter.append(exchangeProperty.getValue());
                stringWriter.append("\n");
            }
        }
        try (OutputStream fileOutputStream = Files.newOutputStream(file, new OpenOption[0]);){
            fileOutputStream.write(stringWriter.getBuffer().toString().getBytes());
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Exchange data saved in " + file);
        }
    }
}

