/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;

@Command(scope="unomi", name="event-view", description="This command will dump an Event as a JSON object")
@Service
public class EventView
implements Action {
    @Reference
    EventService eventService;
    @Reference
    DefinitionsService definitionsService;
    @Argument(index=0, name="event", description="The identifier for the event", required=true, multiValued=false)
    String eventIdentifier;

    public Object execute() throws Exception {
        Condition eventCondition = new Condition(this.definitionsService.getConditionType("eventPropertyCondition"));
        eventCondition.setParameter("propertyName", (Object)"itemId");
        eventCondition.setParameter("comparisonOperator", (Object)"equals");
        eventCondition.setParameter("propertyValue", (Object)this.eventIdentifier);
        PartialList matchingEvents = this.eventService.searchEvents(eventCondition, 0, 10);
        if (matchingEvents == null || matchingEvents.getTotalSize() != 1L) {
            System.out.println("Couldn't find a single event with id=" + this.eventIdentifier + ". Maybe it wasn't a persistent event ?");
            return null;
        }
        String jsonEvent = CustomObjectMapper.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(matchingEvents.get(0));
        System.out.println(jsonEvent);
        return null;
    }
}

