/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class JDBCUtils {
    public static final String DATASOURCE = "datasource";
    public static final String JNDI = "jndi:";
    public static final String OSGI = "osgi:";

    private JDBCUtils() {
    }

    public static DataSource createDatasource(BundleContext bc, String url) throws Exception {
        Object ds = JDBCUtils.doCreateDatasource(bc, url);
        if (ds == null) {
            throw new Exception("Unable to create datasource for " + url);
        }
        return (DataSource)DataSource.class.cast(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object doCreateDatasource(BundleContext bc, String url) throws Exception {
        String string = url = url != null ? url.trim() : null;
        if (url == null || url.isEmpty()) {
            throw new Exception("Illegal datasource url format. Datasource URL cannot be null or empty.");
        }
        if (url.startsWith(JNDI)) {
            String jndiName = url.substring(JNDI.length());
            try (InitialContext ic = new InitialContext();){
                Object object = ic.lookup(jndiName);
                return object;
            }
        }
        if (url.startsWith(OSGI)) {
            ServiceReference[] references;
            String osgiFilter = url.substring(OSGI.length());
            String clazz = null;
            String filter = null;
            String[] tokens = osgiFilter.split("/", 2);
            if (tokens.length > 0) {
                clazz = tokens[0];
            }
            if (tokens.length > 1) {
                filter = tokens[1];
            }
            if ((references = bc.getServiceReferences(clazz, filter)) != null) {
                ServiceReference ref = references[0];
                Object ds = bc.getService(ref);
                bc.ungetService(ref);
                return ds;
            }
            throw new Exception("Unable to find service reference for datasource: " + clazz + "/" + filter);
        }
        throw new Exception("Illegal datasource url format " + url);
    }

    /*
     * Exception decompiling
     */
    protected static int rawUpdate(DataSource dataSource, String query, String ... params) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static int rawUpdate(Connection connection, String query, String ... params) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(query);){
            for (int i = 0; i < params.length; ++i) {
                statement.setString(i + 1, params[i]);
            }
            int n = statement.executeUpdate();
            return n;
        }
    }

    protected static List<String> rawSelect(DataSource dataSource, String query, String ... params) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            List<String> list = JDBCUtils.rawSelect(connection, query, params);
            return list;
        }
    }

    protected static List<String> rawSelect(Connection connection, String query, String ... params) throws SQLException {
        ArrayList<String> results = new ArrayList<String>();
        try (PreparedStatement statement = connection.prepareStatement(query);){
            for (int i = 0; i < params.length; ++i) {
                statement.setString(i + 1, params[i]);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    results.add(resultSet.getString(1));
                }
            }
        }
        return results;
    }
}

