/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(ProxyUtils.class);
    public static final int JAVA_CLASS_VERSION = new BigDecimal(System.getProperty("java.class.version")).intValue();
    private static int weavingJavaVersion = -1;

    public static int getWeavingJavaVersion() {
        if (weavingJavaVersion == -1) {
            switch (JAVA_CLASS_VERSION) {
                case 61: {
                    LOGGER.debug("Weaving to Java 17");
                    weavingJavaVersion = 61;
                    break;
                }
                case 60: {
                    LOGGER.debug("Weaving to Java 16");
                    weavingJavaVersion = 60;
                    break;
                }
                case 59: {
                    LOGGER.debug("Weaving to Java 15");
                    weavingJavaVersion = 59;
                    break;
                }
                case 58: {
                    LOGGER.debug("Weaving to Java 14");
                    weavingJavaVersion = 58;
                    break;
                }
                case 57: {
                    LOGGER.debug("Weaving to Java 13");
                    weavingJavaVersion = 57;
                    break;
                }
                case 56: {
                    LOGGER.debug("Weaving to Java 12");
                    weavingJavaVersion = 56;
                    break;
                }
                case 55: {
                    LOGGER.debug("Weaving to Java 11");
                    weavingJavaVersion = 55;
                    break;
                }
                case 54: {
                    LOGGER.debug("Weaving to Java 10");
                    weavingJavaVersion = 54;
                    break;
                }
                case 53: {
                    LOGGER.debug("Weaving to Java 9");
                    weavingJavaVersion = 53;
                    break;
                }
                case 52: {
                    LOGGER.debug("Weaving to Java 8");
                    weavingJavaVersion = 52;
                    break;
                }
                case 51: {
                    LOGGER.debug("Weaving to Java 7");
                    weavingJavaVersion = 51;
                    break;
                }
                case 50: {
                    LOGGER.debug("Weaving to Java 6");
                    weavingJavaVersion = 50;
                    break;
                }
                case 49: {
                    LOGGER.debug("Weaving to Java 5");
                    weavingJavaVersion = 49;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Java version " + JAVA_CLASS_VERSION);
                }
            }
        }
        return weavingJavaVersion;
    }
}

