/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.control;

import java.util.Dictionary;
import org.apache.karaf.cellar.core.Consumer;
import org.apache.karaf.cellar.core.command.CommandHandler;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.ConsumerSwitchCommand;
import org.apache.karaf.cellar.core.control.ConsumerSwitchResult;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.osgi.service.cm.Configuration;

public class ConsumerSwitchCommandHandler
extends CommandHandler<ConsumerSwitchCommand, ConsumerSwitchResult> {
    public static final String SWITCH_ID = "org.apache.karaf.cellar.command.producer.switch";
    private final Switch commandSwitch = new BasicSwitch("org.apache.karaf.cellar.command.producer.switch");
    private Consumer consumer;

    @Override
    public ConsumerSwitchResult execute(ConsumerSwitchCommand command) {
        if (command.getStatus() == null) {
            return new ConsumerSwitchResult(command.getId(), Boolean.TRUE, this.consumer.getSwitch().getStatus().getValue());
        }
        if (command.getStatus().equals((Object)SwitchStatus.ON)) {
            this.consumer.getSwitch().turnOn();
            this.persist(command.getStatus());
            return new ConsumerSwitchResult(command.getId(), Boolean.TRUE, Boolean.TRUE);
        }
        if (command.getStatus().equals((Object)SwitchStatus.OFF)) {
            this.consumer.getSwitch().turnOff();
            this.persist(command.getStatus());
            return new ConsumerSwitchResult(command.getId(), Boolean.TRUE, Boolean.FALSE);
        }
        return new ConsumerSwitchResult(command.getId(), Boolean.FALSE, this.consumer.getSwitch().getStatus().getValue());
    }

    private void persist(SwitchStatus switchStatus) {
        try {
            Dictionary properties;
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            if (configuration != null && (properties = configuration.getProperties()) != null) {
                properties.put("consumer", switchStatus.getValue().toString());
                configuration.update(properties);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can't persist the consumer status", (Throwable)e);
        }
    }

    @Override
    public Class<ConsumerSwitchCommand> getType() {
        return ConsumerSwitchCommand.class;
    }

    @Override
    public Switch getSwitch() {
        return this.commandSwitch;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }
}

