/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.sc;

import groovyjarjarasm.asm.Handle;
import groovyjarjarasm.asm.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public interface AbstractFunctionalInterfaceWriter {
    public static final String ORIGINAL_PARAMETERS_WITH_EXACT_TYPE = "__ORIGINAL_PARAMETERS_WITH_EXACT_TYPE";

    default public ClassNode getFunctionalInterfaceType(Expression expression) {
        ClassNode type = (ClassNode)expression.getNodeMetaData((Object)StaticTypesMarker.PARAMETER_TYPE);
        if (null == type) {
            type = (ClassNode)expression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_FUNCTIONAL_INTERFACE_TYPE);
        }
        return type;
    }

    default public String createMethodDescriptor(MethodNode abstractMethodNode) {
        return BytecodeHelper.getMethodDescriptor(abstractMethodNode.getReturnType().getTypeClass(), (Class[])Arrays.stream(abstractMethodNode.getParameters()).map(e -> e.getType().getTypeClass()).toArray(Class[]::new));
    }

    default public Handle createBootstrapMethod(boolean isInterface, boolean serializable) {
        if (serializable) {
            return new Handle(6, "java/lang/invoke/LambdaMetafactory", "altMetafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", isInterface);
        }
        return new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", isInterface);
    }

    default public Object[] createBootstrapMethodArguments(String abstractMethodDesc, int insn, ClassNode methodOwnerClassNode, MethodNode methodNode, boolean serializable) {
        Parameter[] parameters = (Parameter[])methodNode.getNodeMetaData(ORIGINAL_PARAMETERS_WITH_EXACT_TYPE);
        LinkedList<Object> argumentList = new LinkedList<Object>();
        argumentList.add(Type.getType(abstractMethodDesc));
        argumentList.add(new Handle(insn, BytecodeHelper.getClassInternalName(methodOwnerClassNode.getName()), methodNode.getName(), BytecodeHelper.getMethodDescriptor(methodNode), methodOwnerClassNode.isInterface()));
        argumentList.add(Type.getType(BytecodeHelper.getMethodDescriptor(methodNode.getReturnType(), parameters)));
        if (serializable) {
            argumentList.add(5);
            argumentList.add(0);
        }
        return argumentList.toArray();
    }

    default public ClassNode convertParameterType(ClassNode parameterType, ClassNode inferredType) {
        boolean isParameterTypePrimitive = ClassHelper.isPrimitiveType(parameterType);
        boolean isInferredTypePrimitive = ClassHelper.isPrimitiveType(inferredType);
        ClassNode type = !isParameterTypePrimitive && isInferredTypePrimitive ? ClassHelper.getWrapper(inferredType) : (isParameterTypePrimitive && !isInferredTypePrimitive ? ClassHelper.getUnwrapper(inferredType) : inferredType);
        return type;
    }

    default public Parameter prependParameter(List<Parameter> methodParameterList, String parameterName, ClassNode parameterType) {
        Parameter parameter = new Parameter(parameterType, parameterName);
        parameter.setOriginType(parameterType);
        parameter.setClosureSharedVariable(false);
        methodParameterList.add(0, parameter);
        return parameter;
    }
}

