/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.helpers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.SyspropsMapWrapper;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.throttle.ChannelStreamPacketWriterResolver;
import org.apache.sshd.common.config.VersionProperties;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.forward.ForwardingFilterFactory;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.io.DefaultIoServiceFactoryFactory;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.kex.AbstractKexFactoryManager;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.UnknownChannelReferenceHandler;
import org.apache.sshd.common.session.helpers.AbstractSessionFactory;
import org.apache.sshd.common.session.helpers.SessionTimeoutListener;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.forward.ForwardingFilter;

public abstract class AbstractFactoryManager
extends AbstractKexFactoryManager
implements FactoryManager {
    protected IoServiceFactoryFactory ioServiceFactoryFactory;
    protected IoServiceFactory ioServiceFactory;
    protected Factory<Random> randomFactory;
    protected List<ChannelFactory> channelFactories;
    protected SshAgentFactory agentFactory;
    protected ScheduledExecutorService executor;
    protected boolean shutdownExecutor;
    protected ForwardingFilterFactory forwarderFactory;
    protected ForwardingFilter forwardingFilter;
    protected FileSystemFactory fileSystemFactory;
    protected List<ServiceFactory> serviceFactories;
    protected List<RequestHandler<ConnectionService>> globalRequestHandlers;
    protected SessionTimeoutListener sessionTimeoutListener;
    protected ScheduledFuture<?> timeoutListenerFuture;
    protected final Collection<SessionListener> sessionListeners = new CopyOnWriteArraySet<SessionListener>();
    protected final SessionListener sessionListenerProxy;
    protected final Collection<ChannelListener> channelListeners = new CopyOnWriteArraySet<ChannelListener>();
    protected final ChannelListener channelListenerProxy;
    protected final Collection<PortForwardingEventListener> tunnelListeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    protected final PortForwardingEventListener tunnelListenerProxy;
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final Map<AttributeRepository.AttributeKey<?>, Object> attributes = new ConcurrentHashMap();
    private PropertyResolver parentResolver = SyspropsMapWrapper.SYSPROPS_RESOLVER;
    private ReservedSessionMessagesHandler reservedSessionMessagesHandler;
    private SessionDisconnectHandler sessionDisconnectHandler;
    private ChannelStreamPacketWriterResolver channelStreamPacketWriterResolver;
    private UnknownChannelReferenceHandler unknownChannelReferenceHandler;
    private IoServiceEventListener eventListener;

    protected AbstractFactoryManager() {
        this.sessionListenerProxy = EventListenerUtils.proxyWrapper(SessionListener.class, this.sessionListeners);
        this.channelListenerProxy = EventListenerUtils.proxyWrapper(ChannelListener.class, this.channelListeners);
        this.tunnelListenerProxy = EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.tunnelListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoServiceFactory getIoServiceFactory() {
        IoServiceFactoryFactory ioServiceFactoryFactory = this.ioServiceFactoryFactory;
        synchronized (ioServiceFactoryFactory) {
            if (this.ioServiceFactory == null) {
                this.ioServiceFactory = this.ioServiceFactoryFactory.create(this);
            }
        }
        return this.ioServiceFactory;
    }

    public IoServiceFactoryFactory getIoServiceFactoryFactory() {
        return this.ioServiceFactoryFactory;
    }

    public void setIoServiceFactoryFactory(IoServiceFactoryFactory ioServiceFactory) {
        this.ioServiceFactoryFactory = ioServiceFactory;
    }

    @Override
    public IoServiceEventListener getIoServiceEventListener() {
        return this.eventListener;
    }

    @Override
    public void setIoServiceEventListener(IoServiceEventListener listener) {
        this.eventListener = listener;
    }

    @Override
    public Factory<Random> getRandomFactory() {
        return this.randomFactory;
    }

    public void setRandomFactory(Factory<Random> randomFactory) {
        this.randomFactory = randomFactory;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes.size();
    }

    @Override
    public <T> T getAttribute(AttributeRepository.AttributeKey<T> key) {
        return (T)this.attributes.get(Objects.requireNonNull(key, "No key"));
    }

    @Override
    public Collection<AttributeRepository.AttributeKey<?>> attributeKeys() {
        return this.attributes.isEmpty() ? Collections.emptySet() : new HashSet(this.attributes.keySet());
    }

    @Override
    public <T> T computeAttributeIfAbsent(AttributeRepository.AttributeKey<T> key, Function<? super AttributeRepository.AttributeKey<T>, ? extends T> resolver) {
        return this.attributes.computeIfAbsent(Objects.requireNonNull(key, "No key"), resolver);
    }

    @Override
    public <T> T setAttribute(AttributeRepository.AttributeKey<T> key, T value) {
        return (T)this.attributes.put(Objects.requireNonNull(key, "No key"), Objects.requireNonNull(value, "No value"));
    }

    @Override
    public <T> T removeAttribute(AttributeRepository.AttributeKey<T> key) {
        return (T)this.attributes.remove(Objects.requireNonNull(key, "No key"));
    }

    @Override
    public void clearAttributes() {
        this.attributes.clear();
    }

    @Override
    public PropertyResolver getParentPropertyResolver() {
        return this.parentResolver;
    }

    public void setParentPropertyResolver(PropertyResolver parent) {
        this.parentResolver = parent;
    }

    @Override
    public String getVersion() {
        String version = PropertyResolverUtils.getStringProperty(VersionProperties.getVersionProperties(), "sshd-version", "SSHD-UNKNOWN");
        return version.toUpperCase();
    }

    @Override
    public List<ChannelFactory> getChannelFactories() {
        return this.channelFactories;
    }

    public void setChannelFactories(List<ChannelFactory> channelFactories) {
        this.channelFactories = channelFactories;
    }

    public int getNioWorkers() {
        int nb = this.getIntProperty("nio-workers", DEFAULT_NIO_WORKERS);
        if (nb > 0) {
            return nb;
        }
        return DEFAULT_NIO_WORKERS;
    }

    public void setNioWorkers(int nioWorkers) {
        if (nioWorkers > 0) {
            PropertyResolverUtils.updateProperty((PropertyResolver)this, "nio-workers", nioWorkers);
        } else {
            PropertyResolverUtils.updateProperty((PropertyResolver)this, "nio-workers", null);
        }
    }

    @Override
    public SshAgentFactory getAgentFactory() {
        return this.agentFactory;
    }

    public void setAgentFactory(SshAgentFactory agentFactory) {
        this.agentFactory = agentFactory;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.executor;
    }

    public void setScheduledExecutorService(ScheduledExecutorService executor) {
        this.setScheduledExecutorService(executor, false);
    }

    public void setScheduledExecutorService(ScheduledExecutorService executor, boolean shutdownExecutor) {
        this.executor = executor;
        this.shutdownExecutor = shutdownExecutor;
    }

    @Override
    public ForwardingFilterFactory getForwarderFactory() {
        return this.forwarderFactory;
    }

    public void setForwarderFactory(ForwardingFilterFactory forwarderFactory) {
        this.forwarderFactory = forwarderFactory;
    }

    @Override
    public ForwardingFilter getForwardingFilter() {
        return this.forwardingFilter;
    }

    public void setForwardingFilter(ForwardingFilter forwardingFilter) {
        this.forwardingFilter = forwardingFilter;
    }

    @Override
    public FileSystemFactory getFileSystemFactory() {
        return this.fileSystemFactory;
    }

    public void setFileSystemFactory(FileSystemFactory fileSystemFactory) {
        this.fileSystemFactory = fileSystemFactory;
    }

    @Override
    public List<ServiceFactory> getServiceFactories() {
        return this.serviceFactories;
    }

    public void setServiceFactories(List<ServiceFactory> serviceFactories) {
        this.serviceFactories = serviceFactories;
    }

    @Override
    public List<RequestHandler<ConnectionService>> getGlobalRequestHandlers() {
        return this.globalRequestHandlers;
    }

    public void setGlobalRequestHandlers(List<RequestHandler<ConnectionService>> globalRequestHandlers) {
        this.globalRequestHandlers = globalRequestHandlers;
    }

    @Override
    public ReservedSessionMessagesHandler getReservedSessionMessagesHandler() {
        return this.reservedSessionMessagesHandler;
    }

    @Override
    public void setReservedSessionMessagesHandler(ReservedSessionMessagesHandler handler) {
        this.reservedSessionMessagesHandler = handler;
    }

    @Override
    public SessionDisconnectHandler getSessionDisconnectHandler() {
        return this.sessionDisconnectHandler;
    }

    @Override
    public void setSessionDisconnectHandler(SessionDisconnectHandler sessionDisconnectHandler) {
        this.sessionDisconnectHandler = sessionDisconnectHandler;
    }

    @Override
    public ChannelStreamPacketWriterResolver getChannelStreamPacketWriterResolver() {
        return this.channelStreamPacketWriterResolver;
    }

    @Override
    public void setChannelStreamPacketWriterResolver(ChannelStreamPacketWriterResolver resolver) {
        this.channelStreamPacketWriterResolver = resolver;
    }

    @Override
    public UnknownChannelReferenceHandler getUnknownChannelReferenceHandler() {
        return this.unknownChannelReferenceHandler;
    }

    @Override
    public void setUnknownChannelReferenceHandler(UnknownChannelReferenceHandler unknownChannelReferenceHandler) {
        this.unknownChannelReferenceHandler = unknownChannelReferenceHandler;
    }

    @Override
    public UnknownChannelReferenceHandler resolveUnknownChannelReferenceHandler() {
        return this.getUnknownChannelReferenceHandler();
    }

    @Override
    public void addSessionListener(SessionListener listener) {
        SessionListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addSessionListener({})[{}] ignore registration while manager is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.sessionListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addSessionListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addSessionListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removeSessionListener(SessionListener listener) {
        if (listener == null) {
            return;
        }
        SessionListener.validateListener(listener);
        if (this.sessionListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeSessionListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeSessionListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public SessionListener getSessionListenerProxy() {
        return this.sessionListenerProxy;
    }

    @Override
    public void addChannelListener(ChannelListener listener) {
        ChannelListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addChannelListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.channelListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addChannelListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addChannelListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removeChannelListener(ChannelListener listener) {
        if (listener == null) {
            return;
        }
        ChannelListener.validateListener(listener);
        if (this.channelListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeChannelListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeChannelListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public ChannelListener getChannelListenerProxy() {
        return this.channelListenerProxy;
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.tunnelListenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        PortForwardingEventListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addPortForwardingEventListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.tunnelListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addPortForwardingEventListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addPortForwardingEventListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        PortForwardingEventListener.validateListener(listener);
        if (this.tunnelListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removePortForwardingEventListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removePortForwardingEventListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    protected void setupSessionTimeout(AbstractSessionFactory<?, ?> sessionFactory) {
        this.sessionTimeoutListener = this.createSessionTimeoutListener();
        this.addSessionListener(this.sessionTimeoutListener);
        this.timeoutListenerFuture = this.getScheduledExecutorService().scheduleAtFixedRate(this.sessionTimeoutListener, 1L, 1L, TimeUnit.SECONDS);
    }

    protected void removeSessionTimeout(AbstractSessionFactory<?, ?> sessionFactory) {
        this.stopSessionTimeoutListener(sessionFactory);
    }

    protected SessionTimeoutListener createSessionTimeoutListener() {
        return new SessionTimeoutListener();
    }

    protected void stopSessionTimeoutListener(AbstractSessionFactory<?, ?> sessionFactory) {
        if (this.timeoutListenerFuture != null) {
            try {
                this.timeoutListenerFuture.cancel(true);
            }
            finally {
                this.timeoutListenerFuture = null;
            }
        }
        if (this.sessionTimeoutListener != null) {
            try {
                this.removeSessionListener(this.sessionTimeoutListener);
            }
            finally {
                this.sessionTimeoutListener = null;
            }
        }
    }

    protected void checkConfig() {
        ValidateUtils.checkNotNullAndNotEmpty(this.getKeyExchangeFactories(), "KeyExchangeFactories not set", new Object[0]);
        if (this.getScheduledExecutorService() == null) {
            this.setScheduledExecutorService(ThreadUtils.newSingleThreadScheduledExecutor(this.toString() + "-timer"), true);
        }
        ValidateUtils.checkNotNullAndNotEmpty(this.getCipherFactories(), "CipherFactories not set", new Object[0]);
        ValidateUtils.checkNotNullAndNotEmpty(this.getCompressionFactories(), "CompressionFactories not set", new Object[0]);
        ValidateUtils.checkNotNullAndNotEmpty(this.getMacFactories(), "MacFactories not set", new Object[0]);
        Objects.requireNonNull(this.getRandomFactory(), "RandomFactory not set");
        if (this.getIoServiceFactoryFactory() == null) {
            DefaultIoServiceFactoryFactory defaultFactory = DefaultIoServiceFactoryFactory.getDefaultIoServiceFactoryFactoryInstance();
            this.setIoServiceFactoryFactory(defaultFactory);
        }
    }
}

