/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ScanResultObject;
import java.lang.reflect.Field;
import java.util.Set;

public class AnnotationEnumValue
extends ScanResultObject
implements Comparable<AnnotationEnumValue> {
    private String className;
    private String valueName;

    AnnotationEnumValue() {
    }

    AnnotationEnumValue(String className, String constValueName) {
        this.className = className;
        this.valueName = constValueName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public String getValueName() {
        return this.valueName;
    }

    public String getName() {
        return this.className + "." + this.valueName;
    }

    public Object loadClassAndReturnEnumValue(boolean ignoreExceptions) throws IllegalArgumentException {
        Field field;
        Class<?> classRef = super.loadClass();
        if (!classRef.isEnum()) {
            throw new IllegalArgumentException("Class " + this.className + " is not an enum");
        }
        try {
            field = classRef.getDeclaredField(this.valueName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find enum constant " + this.toString(), e);
        }
        if (!field.isEnumConstant()) {
            throw new IllegalArgumentException("Field " + this.toString() + " is not an enum constant");
        }
        try {
            return field.get(null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Field " + this.toString() + " is not accessible", e);
        }
    }

    public Object loadClassAndReturnEnumValue() throws IllegalArgumentException {
        return this.loadClassAndReturnEnumValue(false);
    }

    @Override
    void getReferencedClassNames(Set<String> referencedClassNames) {
        referencedClassNames.add(this.className);
    }

    @Override
    public int compareTo(AnnotationEnumValue o) {
        int diff = this.className.compareTo(o.className);
        return diff == 0 ? this.valueName.compareTo(o.valueName) : diff;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnnotationEnumValue)) {
            return false;
        }
        return this.compareTo((AnnotationEnumValue)o) == 0;
    }

    public int hashCode() {
        return this.className.hashCode() * 11 + this.valueName.hashCode();
    }

    public String toString() {
        return this.className + "." + this.valueName;
    }
}

