/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.money.NumberValue;
import javax.money.convert.ConversionContext;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ConversionQuery;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LazyBoundCurrencyConversion;
import org.javamoney.moneta.spi.MonetaryConfig;

public abstract class AbstractRateProvider
implements ExchangeRateProvider {
    private final ProviderContext context;
    @Deprecated
    protected final Logger log = Logger.getLogger(this.getClass().getName());

    public AbstractRateProvider(ProviderContext providerContext) {
        Objects.requireNonNull(providerContext);
        this.context = providerContext;
    }

    public ProviderContext getContext() {
        return this.context;
    }

    public abstract ExchangeRate getExchangeRate(ConversionQuery var1);

    public CurrencyConversion getCurrencyConversion(ConversionQuery conversionQuery) {
        if (this.getContext().getRateTypes().size() == 1) {
            return new LazyBoundCurrencyConversion(conversionQuery, this, ConversionContext.of((String)this.getContext().getProviderName(), (RateType)((RateType)this.getContext().getRateTypes().iterator().next())));
        }
        return new LazyBoundCurrencyConversion(conversionQuery, this, ConversionContext.of((String)this.getContext().getProviderName(), (RateType)RateType.ANY));
    }

    protected static NumberValue multiply(NumberValue multiplicand, NumberValue multiplier) {
        if (Objects.isNull(multiplicand)) {
            throw new ArithmeticException("The multiplicand cannot be null");
        }
        if (Objects.isNull(multiplier)) {
            throw new ArithmeticException("The multiplier cannot be null");
        }
        return new DefaultNumberValue(((BigDecimal)multiplicand.numberValueExact(BigDecimal.class)).multiply((BigDecimal)multiplier.numberValue(BigDecimal.class)));
    }

    protected static NumberValue divide(NumberValue dividend, NumberValue divisor) {
        if (Objects.isNull(dividend)) {
            throw new ArithmeticException("The dividend cannot be null");
        }
        if (Objects.isNull(divisor)) {
            throw new ArithmeticException("The divisor cannot be null");
        }
        return new DefaultNumberValue(((BigDecimal)dividend.numberValueExact(BigDecimal.class)).divide((BigDecimal)divisor.numberValue(BigDecimal.class), MathContext.DECIMAL64));
    }

    protected static NumberValue divide(NumberValue dividend, NumberValue divisor, MathContext context) {
        if (Objects.isNull(dividend)) {
            throw new ArithmeticException("The dividend cannot be null");
        }
        if (Objects.isNull(divisor)) {
            throw new ArithmeticException("The divisor cannot be null");
        }
        return new DefaultNumberValue(((BigDecimal)dividend.numberValueExact(BigDecimal.class)).divide((BigDecimal)divisor.numberValue(BigDecimal.class), context));
    }

    protected int getScale(String key) {
        String string = MonetaryConfig.getConfig().getOrDefault(key, "-1");
        if (string.isEmpty()) {
            return -1;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected ConversionContext getExchangeContext(String key) {
        int scale = this.getScale(key);
        if (scale < 0) {
            return ConversionContext.of((String)this.context.getProviderName(), (RateType)RateType.HISTORIC);
        }
        return ((ConversionContextBuilder)ConversionContext.of((String)this.context.getProviderName(), (RateType)RateType.HISTORIC).toBuilder().set("exchangeRateScale", scale)).build();
    }

    protected LocalDate[] getQueryDates(ConversionQuery query) {
        if (Objects.nonNull(query.get(LocalDate.class)) || Objects.nonNull(query.get(LocalDateTime.class))) {
            LocalDate localDate = Optional.ofNullable(query.get(LocalDate.class)).orElseGet(() -> ((LocalDateTime)query.get(LocalDateTime.class)).toLocalDate());
            return new LocalDate[]{localDate};
        }
        if (Objects.nonNull(query.get(LocalDate[].class))) {
            return (LocalDate[])query.get(LocalDate[].class);
        }
        return null;
    }
}

