/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch.conditions;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.charfilter.MappingCharFilterFactory;
import org.apache.lucene.analysis.util.ClasspathResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.scripting.ScriptExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionContextHelper {
    private static final Logger logger = LoggerFactory.getLogger(ConditionContextHelper.class);
    private static MappingCharFilterFactory mappingCharFilterFactory;

    public static Condition getContextualCondition(Condition condition, Map<String, Object> context, ScriptExecutor scriptExecutor) {
        if (!ConditionContextHelper.hasContextualParameter(condition.getParameterValues())) {
            return condition;
        }
        Map values = (Map)ConditionContextHelper.parseParameter(context, condition.getParameterValues(), scriptExecutor);
        if (values == null) {
            return null;
        }
        Condition n = new Condition(condition.getConditionType());
        n.setParameterValues(values);
        return n;
    }

    private static Object parseParameter(Map<String, Object> context, Object value, ScriptExecutor scriptExecutor) {
        if (value instanceof String) {
            if (((String)value).startsWith("parameter::") || ((String)value).startsWith("script::")) {
                String s = (String)value;
                if (s.startsWith("parameter::")) {
                    return context.get(StringUtils.substringAfter((String)s, (String)"parameter::"));
                }
                if (s.startsWith("script::")) {
                    String script = StringUtils.substringAfter((String)s, (String)"script::");
                    return scriptExecutor.execute(script, context);
                }
            }
        } else {
            if (value instanceof Map) {
                HashMap values = new HashMap();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    Object parameter = ConditionContextHelper.parseParameter(context, entry.getValue(), scriptExecutor);
                    if (parameter == null) {
                        return null;
                    }
                    values.put(entry.getKey(), parameter);
                }
                return values;
            }
            if (value instanceof List) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object o : (List)value) {
                    Object parameter = ConditionContextHelper.parseParameter(context, o, scriptExecutor);
                    if (parameter == null) continue;
                    values.add(parameter);
                }
                return values;
            }
        }
        return value;
    }

    private static boolean hasContextualParameter(Object value) {
        block4: {
            block5: {
                block3: {
                    if (!(value instanceof String)) break block3;
                    if (((String)value).startsWith("parameter::") || ((String)value).startsWith("script::")) {
                        return true;
                    }
                    break block4;
                }
                if (!(value instanceof Map)) break block5;
                for (Object o : ((Map)value).values()) {
                    if (!ConditionContextHelper.hasContextualParameter(o)) continue;
                    return true;
                }
                break block4;
            }
            if (!(value instanceof List)) break block4;
            for (Object o : (List)value) {
                if (!ConditionContextHelper.hasContextualParameter(o)) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] foldToASCII(String[] s) {
        if (s != null) {
            for (int i = 0; i < s.length; ++i) {
                s[i] = ConditionContextHelper.foldToASCII(s[i]);
            }
        }
        return s;
    }

    /*
     * Exception decompiling
     */
    public static String foldToASCII(String s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> Collection<T> foldToASCII(Collection<T> s) {
        if (s != null) {
            return Collections2.transform(s, (Function)new Function<T, T>(){

                public T apply(T o) {
                    if (o instanceof String) {
                        return ConditionContextHelper.foldToASCII((String)o);
                    }
                    return o;
                }
            });
        }
        return null;
    }

    static {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("mapping", "mapping-FoldToASCII.txt");
        mappingCharFilterFactory = new MappingCharFilterFactory(args);
        try {
            mappingCharFilterFactory.inform((ResourceLoader)new ClasspathResourceLoader(ConditionContextHelper.class.getClassLoader()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

