/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.service.result;

import aQute.bnd.service.result.ConsumerWithException;
import aQute.bnd.service.result.Exceptions;
import aQute.bnd.service.result.FunctionWithException;
import aQute.bnd.service.result.Ok;
import aQute.bnd.service.result.Result;
import aQute.bnd.service.result.ResultException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Err<V, E>
implements Result<V, E> {
    private final E error;

    Err(E error) {
        this.error = Objects.requireNonNull(error);
    }

    @Override
    public boolean isOk() {
        return false;
    }

    @Override
    public boolean isErr() {
        return true;
    }

    @Override
    public Optional<V> value() {
        return Optional.empty();
    }

    @Override
    public Optional<E> error() {
        return Optional.of(this.error);
    }

    @Override
    public V unwrap() {
        throw new ResultException("Cannot call unwrap() on an Err value");
    }

    @Override
    public V unwrap(String message) throws ResultException {
        throw new ResultException(message);
    }

    @Override
    public V orElse(V orElse) {
        return orElse;
    }

    @Override
    public V orElseGet(Supplier<? extends V> orElseSupplier) {
        Objects.requireNonNull(orElseSupplier);
        return orElseSupplier.get();
    }

    @Override
    public <R extends Throwable> V orElseThrow(FunctionWithException<? super E, ? extends R> throwableSupplier) throws R {
        Throwable r;
        Objects.requireNonNull(throwableSupplier);
        try {
            r = (Throwable)Objects.requireNonNull(throwableSupplier.apply(this.error));
        }
        catch (Exception e) {
            throw new ResultException(e);
        }
        throw r;
    }

    private <U> Result<U, E> coerce() {
        return this;
    }

    @Override
    public <U> Result<U, E> map(FunctionWithException<? super V, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.coerce();
    }

    @Override
    public <F> Result<V, F> mapErr(FunctionWithException<? super E, ? extends F> mapper) {
        Objects.requireNonNull(mapper);
        try {
            return new Err<V, F>(mapper.apply(this.error));
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    @Override
    public <U> Result<U, E> flatMap(FunctionWithException<? super V, ? extends Result<? extends U, ? extends E>> mapper) {
        Objects.requireNonNull(mapper);
        return this.coerce();
    }

    @Override
    public Result<V, E> recover(FunctionWithException<? super E, ? extends V> recover) {
        Objects.requireNonNull(recover);
        try {
            return new Ok(recover.apply(this.error));
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    @Override
    public void accept(ConsumerWithException<? super V> ok, ConsumerWithException<? super E> err) {
        Objects.requireNonNull(ok);
        try {
            err.accept(this.error);
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    public String toString() {
        return String.format("Err(%s)", this.error);
    }

    @Override
    public <X> Result<X, E> asError() {
        return this.coerce();
    }

    @Override
    public <X extends Throwable> V unwrap(Function<E, X> constructor) throws X {
        throw (Throwable)constructor.apply(this.error);
    }
}

