/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.rest;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.router.api.ExportConfiguration;
import org.apache.unomi.router.api.services.ImportExportConfigurationService;
import org.apache.unomi.router.api.services.ProfileExportService;
import org.apache.unomi.router.rest.AbstractConfigurationServiceEndpoint;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/exportConfiguration")
@Component(service={ExportConfigurationServiceEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class ExportConfigurationServiceEndPoint
extends AbstractConfigurationServiceEndpoint<ExportConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger((String)ExportConfigurationServiceEndPoint.class.getName());
    @Reference
    private ProfileExportService profileExportService;
    @Reference
    private ProfileService profileService;

    public ExportConfigurationServiceEndPoint() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        logger.info("Initializing export configuration service endpoint...");
    }

    @WebMethod(exclude=true)
    @Reference(target="(configDiscriminator=EXPORT)")
    public void setExportConfigurationService(ImportExportConfigurationService<ExportConfiguration> exportConfigurationService) {
        this.configurationService = exportConfigurationService;
    }

    @WebMethod(exclude=true)
    public void setProfileExportService(ProfileExportService profileExportService) {
        this.profileExportService = profileExportService;
    }

    @WebMethod(exclude=true)
    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    @Override
    public ExportConfiguration saveConfiguration(ExportConfiguration exportConfiguration) {
        ExportConfiguration exportConfigSaved = (ExportConfiguration)this.configurationService.save((Object)exportConfiguration, true);
        return exportConfigSaved;
    }

    @Override
    public void deleteConfiguration(String configId) {
        this.configurationService.delete(configId);
    }

    @POST
    @Path(value="/oneshot")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv"})
    public Response processOneshotImportConfigurationCSV(ExportConfiguration exportConfiguration) {
        String csvContent = this.profileExportService.extractProfilesBySegment(exportConfiguration);
        Response.ResponseBuilder response = Response.ok((Object)csvContent);
        response.header("Content-Disposition", (Object)("attachment; filename=Profiles_export_" + new SimpleDateFormat("yyyy-MM-dd-HH-mm").format(new Date()) + ".csv"));
        return response.build();
    }
}

