/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.NumberFormat;
import java.util.Objects;
import javax.money.MonetaryAmount;
import javax.money.MonetaryOperator;

final class PercentOperator
implements MonetaryOperator {
    private static final BigDecimal ONE_HUNDRED = new BigDecimal(100, MathContext.DECIMAL64);
    private final BigDecimal percentValue;

    PercentOperator(BigDecimal decimal) {
        this.percentValue = PercentOperator.calcPercent(decimal);
    }

    public MonetaryAmount apply(MonetaryAmount amount) {
        Objects.requireNonNull(amount, "Amount required.");
        return amount.multiply((Number)this.percentValue);
    }

    public String toString() {
        return NumberFormat.getPercentInstance().format(this.percentValue);
    }

    private static BigDecimal calcPercent(BigDecimal decimal) {
        return decimal.divide(ONE_HUNDRED, MathContext.DECIMAL64);
    }
}

