/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassRefOrTypeVariableSignature;
import io.github.classgraph.ScanResult;
import io.github.classgraph.TypeArgument;
import io.github.classgraph.TypeSignature;
import io.github.classgraph.TypeVariableSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import nonapi.io.github.classgraph.types.Parser;
import nonapi.io.github.classgraph.types.TypeUtils;

public class ClassRefTypeSignature
extends ClassRefOrTypeVariableSignature {
    final String className;
    private String fullyQualifiedClassName;
    private final List<TypeArgument> typeArguments;
    private final List<String> suffixes;
    private final List<List<TypeArgument>> suffixTypeArguments;

    private ClassRefTypeSignature(String className, List<TypeArgument> typeArguments, List<String> suffixes, List<List<TypeArgument>> suffixTypeArguments) {
        this.className = className;
        this.typeArguments = typeArguments;
        this.suffixes = suffixes;
        this.suffixTypeArguments = suffixTypeArguments;
    }

    public String getBaseClassName() {
        return this.className;
    }

    public String getFullyQualifiedClassName() {
        if (this.fullyQualifiedClassName == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.className);
            for (String suffix : this.suffixes) {
                buf.append('$');
                buf.append(suffix);
            }
            this.fullyQualifiedClassName = buf.toString();
        }
        return this.fullyQualifiedClassName;
    }

    public List<TypeArgument> getTypeArguments() {
        return this.typeArguments;
    }

    public List<String> getSuffixes() {
        return this.suffixes;
    }

    public List<List<TypeArgument>> getSuffixTypeArguments() {
        return this.suffixTypeArguments;
    }

    @Override
    public Class<?> loadClass(boolean ignoreExceptions) {
        return super.loadClass(ignoreExceptions);
    }

    @Override
    public Class<?> loadClass() {
        return super.loadClass();
    }

    @Override
    protected String getClassName() {
        return this.getFullyQualifiedClassName();
    }

    @Override
    public ClassInfo getClassInfo() {
        return super.getClassInfo();
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.typeArguments != null) {
            for (TypeArgument typeArgument : this.typeArguments) {
                typeArgument.setScanResult(scanResult);
            }
        }
        if (this.suffixTypeArguments != null) {
            for (List list : this.suffixTypeArguments) {
                for (TypeArgument typeArgument : list) {
                    typeArgument.setScanResult(scanResult);
                }
            }
        }
    }

    @Override
    void getReferencedClassNames(Set<String> classNameListOut) {
        classNameListOut.add(this.className);
        classNameListOut.add(this.getFullyQualifiedClassName());
        for (TypeArgument typeArgument : this.typeArguments) {
            typeArgument.getReferencedClassNames(classNameListOut);
        }
    }

    public int hashCode() {
        return this.className.hashCode() + 7 * this.typeArguments.hashCode() + 15 * this.suffixes.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassRefTypeSignature)) {
            return false;
        }
        ClassRefTypeSignature o = (ClassRefTypeSignature)obj;
        return o.className.equals(this.className) && o.typeArguments.equals(this.typeArguments) && o.suffixes.equals(this.suffixes);
    }

    @Override
    public boolean equalsIgnoringTypeParams(TypeSignature other) {
        if (other instanceof TypeVariableSignature) {
            return other.equalsIgnoringTypeParams(this);
        }
        if (!(other instanceof ClassRefTypeSignature)) {
            return false;
        }
        ClassRefTypeSignature o = (ClassRefTypeSignature)other;
        if (o.suffixes.equals(this.suffixes)) {
            return o.className.equals(this.className);
        }
        return o.getFullyQualifiedClassName().equals(this.getFullyQualifiedClassName());
    }

    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append(this.className);
        if (!this.typeArguments.isEmpty()) {
            buf.append('<');
            for (i = 0; i < this.typeArguments.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.typeArguments.get(i).toString());
            }
            buf.append('>');
        }
        for (i = 0; i < this.suffixes.size(); ++i) {
            buf.append('.');
            buf.append(this.suffixes.get(i));
            List<TypeArgument> suffixTypeArgs = this.suffixTypeArguments.get(i);
            if (suffixTypeArgs.isEmpty()) continue;
            buf.append('<');
            for (int j = 0; j < suffixTypeArgs.size(); ++j) {
                if (j > 0) {
                    buf.append(", ");
                }
                buf.append(suffixTypeArgs.get(j).toString());
            }
            buf.append('>');
        }
        return buf.toString();
    }

    static ClassRefTypeSignature parse(Parser parser, String definingClassName) throws Parser.ParseException {
        if (parser.peek() == 'L') {
            List<List<TypeArgument>> suffixTypeArguments;
            List<String> suffixes;
            parser.next();
            if (!TypeUtils.getIdentifierToken(parser, '/', '.')) {
                throw new Parser.ParseException(parser, "Could not parse identifier token");
            }
            String className = parser.currToken();
            List<TypeArgument> typeArguments = TypeArgument.parseList(parser, definingClassName);
            if (parser.peek() == '.') {
                suffixes = new ArrayList();
                suffixTypeArguments = new ArrayList();
                while (parser.peek() == '.') {
                    parser.expect('.');
                    if (!TypeUtils.getIdentifierToken(parser, '/', '.')) {
                        throw new Parser.ParseException(parser, "Could not parse identifier token");
                    }
                    suffixes.add(parser.currToken());
                    suffixTypeArguments.add(TypeArgument.parseList(parser, definingClassName));
                }
            } else {
                suffixes = Collections.emptyList();
                suffixTypeArguments = Collections.emptyList();
            }
            parser.expect(';');
            return new ClassRefTypeSignature(className, typeArguments, suffixes, suffixTypeArguments);
        }
        return null;
    }
}

