/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.message.Message;

public abstract class AbstractResponseContextImpl {
    protected Message m;
    protected ResponseImpl r;

    public AbstractResponseContextImpl(ResponseImpl r, Message m) {
        this.m = m;
        this.r = r;
    }

    public Set<String> getAllowedMethods() {
        return this.r.getAllowedMethods();
    }

    public Map<String, NewCookie> getCookies() {
        return this.r.getCookies();
    }

    public Date getDate() {
        return this.r.getDate();
    }

    public Object getEntity() {
        return this.r.getEntity();
    }

    public EntityTag getEntityTag() {
        return this.r.getEntityTag();
    }

    public String getHeaderString(String name) {
        return this.r.getHeaderString(name);
    }

    public Locale getLanguage() {
        return this.r.getLanguage();
    }

    public Date getLastModified() {
        return this.r.getLastModified();
    }

    public int getLength() {
        return this.r.getLength();
    }

    public Link getLink(String rel) {
        return this.r.getLink(rel);
    }

    public Link.Builder getLinkBuilder(String rel) {
        return this.r.getLinkBuilder(rel);
    }

    public Set<Link> getLinks() {
        return this.r.getLinks();
    }

    public URI getLocation() {
        return this.r.getLocation();
    }

    public MediaType getMediaType() {
        return this.r.getMediaType();
    }

    public int getStatus() {
        return this.r.getStatus();
    }

    public Response.StatusType getStatusInfo() {
        return this.r.getStatusInfo();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.r.getStringHeaders();
    }

    public boolean hasEntity() {
        return this.r.hasEntity();
    }

    public boolean hasLink(String rel) {
        return this.r.hasLink(rel);
    }

    public void setEntity(Object entity, Annotation[] anns, MediaType mt) {
        this.r.setEntity(entity, anns);
        if (mt != null) {
            this.r.getMetadata().putSingle((Object)"Content-Type", (Object)mt);
            this.m.put((Object)"Content-Type", (Object)mt.toString());
        }
    }

    public void setEntity(Object entity) {
        this.r.setEntity(entity, this.getResponseEntityAnnotations());
    }

    protected Annotation[] getResponseEntityAnnotations() {
        return this.r.getEntityAnnotations();
    }

    public void setStatus(int status) {
        this.m.getExchange().put((Object)Message.RESPONSE_CODE, (Object)status);
        this.m.put((Object)Message.RESPONSE_CODE, (Object)status);
        this.r.setStatus(status);
    }

    public void setStatusInfo(Response.StatusType status) {
        this.setStatus(status.getStatusCode());
    }
}

