/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;

public class WebAppServlet {
    private String servletName;
    private String servletClassName;
    private Class<? extends Servlet> servletClass;
    private final List<WebAppInitParam> initParams;
    private final Set<String> aliases = new HashSet<String>();
    private int loadOnStartup;
    private boolean asyncSupported;
    private MultipartConfigElement multipartConfigurations;

    public WebAppServlet() {
        this.initParams = new ArrayList<WebAppInitParam>();
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        NullArgumentException.validateNotNull(servletName, "Servlet name");
        this.servletName = servletName;
        WebAppInitParam initParam = new WebAppInitParam();
        initParam.setParamName("servlet-name");
        initParam.setParamValue(servletName);
        this.initParams.add(initParam);
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public void setServletClassName(String servletClassName) {
        NullArgumentException.validateNotNull(servletClassName, "Servlet class name");
        this.servletClassName = servletClassName;
    }

    public Class<? extends Servlet> getServletClass() {
        return this.servletClass;
    }

    public void setServletClass(Class<? extends Servlet> servletClass) {
        this.servletClass = servletClass;
    }

    public String[] getAliases() {
        return this.aliases.toArray(new String[this.aliases.size()]);
    }

    public void addUrlPattern(String urlPattern) {
        NullArgumentException.validateNotNull(urlPattern, "Url pattern");
        this.aliases.add(urlPattern);
    }

    public void addInitParam(WebAppInitParam param) {
        NullArgumentException.validateNotNull(param, "Init param");
        NullArgumentException.validateNotNull(param.getParamName(), "Init param name");
        NullArgumentException.validateNotNull(param.getParamValue(), "Init param value");
        this.initParams.add(param);
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfigElement) {
        NullArgumentException.validateNotNull(multipartConfigElement, "MultipartConfig");
        this.multipartConfigurations = multipartConfigElement;
    }

    public WebAppInitParam[] getInitParams() {
        return this.initParams.toArray(new WebAppInitParam[this.initParams.size()]);
    }

    public MultipartConfigElement getMultipartConfig() {
        return this.multipartConfigurations;
    }

    public void setLoadOnStartup(String value) {
        if (value != null) {
            try {
                this.loadOnStartup = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.loadOnStartup = Integer.MAX_VALUE;
            }
        } else {
            this.loadOnStartup = Integer.MAX_VALUE;
        }
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public void setAsyncSupported(String value) {
        if (value != null) {
            this.asyncSupported = Boolean.parseBoolean(value);
        }
    }

    public Boolean getAsyncSupported() {
        return this.asyncSupported;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "servletName=" + this.servletName + ",servletClass=" + this.servletClassName + ",aliases=" + this.aliases + "}";
    }
}

