/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.imap;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;
import org.apache.commons.net.imap.IMAP;
import org.apache.commons.net.imap.IMAPCommand;
import org.apache.commons.net.imap.IMAPReply;
import org.apache.commons.net.imap.IMAPSClient;

public class AuthenticatingIMAPClient
extends IMAPSClient {
    private static final String MAC_ALGORITHM = "HmacMD5";

    public AuthenticatingIMAPClient() {
        this("TLS", false);
    }

    public AuthenticatingIMAPClient(boolean implicit) {
        this("TLS", implicit);
    }

    public AuthenticatingIMAPClient(boolean implicit, SSLContext ctx) {
        this("TLS", implicit, ctx);
    }

    public AuthenticatingIMAPClient(SSLContext context) {
        this(false, context);
    }

    public AuthenticatingIMAPClient(String proto) {
        this(proto, false);
    }

    public AuthenticatingIMAPClient(String proto, boolean implicit) {
        this(proto, implicit, null);
    }

    public AuthenticatingIMAPClient(String proto, boolean implicit, SSLContext ctx) {
        super(proto, implicit, ctx);
    }

    public boolean auth(AUTH_METHOD method, String user, String password) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        if (!IMAPReply.isContinuation(this.sendCommand(IMAPCommand.AUTHENTICATE, method.getAuthName()))) {
            return false;
        }
        switch (method) {
            case PLAIN: {
                int result = this.sendData(Base64.getEncoder().encodeToString(("\u0000" + user + "\u0000" + password).getBytes(this.getCharset())));
                if (result == 0) {
                    this.setState(IMAP.IMAPState.AUTH_STATE);
                }
                return result == 0;
            }
            case CRAM_MD5: {
                byte[] serverChallenge = Base64.getDecoder().decode(this.getReplyString().substring(2).trim());
                Mac hmacMd5 = Mac.getInstance(MAC_ALGORITHM);
                hmacMd5.init(new SecretKeySpec(password.getBytes(this.getCharset()), MAC_ALGORITHM));
                byte[] hmacResult = this.convertToHexString(hmacMd5.doFinal(serverChallenge)).getBytes(this.getCharset());
                byte[] usernameBytes = user.getBytes(this.getCharset());
                byte[] toEncode = new byte[usernameBytes.length + 1 + hmacResult.length];
                System.arraycopy(usernameBytes, 0, toEncode, 0, usernameBytes.length);
                toEncode[usernameBytes.length] = 32;
                System.arraycopy(hmacResult, 0, toEncode, usernameBytes.length + 1, hmacResult.length);
                int result = this.sendData(Base64.getEncoder().encodeToString(toEncode));
                if (result == 0) {
                    this.setState(IMAP.IMAPState.AUTH_STATE);
                }
                return result == 0;
            }
            case LOGIN: {
                if (this.sendData(Base64.getEncoder().encodeToString(user.getBytes(this.getCharset()))) != 3) {
                    return false;
                }
                int result = this.sendData(Base64.getEncoder().encodeToString(password.getBytes(this.getCharset())));
                if (result == 0) {
                    this.setState(IMAP.IMAPState.AUTH_STATE);
                }
                return result == 0;
            }
            case XOAUTH: 
            case XOAUTH2: {
                int result = this.sendData(user);
                if (result == 0) {
                    this.setState(IMAP.IMAPState.AUTH_STATE);
                }
                return result == 0;
            }
        }
        return false;
    }

    public boolean authenticate(AUTH_METHOD method, String user, String password) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        return this.auth(method, user, password);
    }

    private String convertToHexString(byte[] a) {
        StringBuilder result = new StringBuilder(a.length * 2);
        for (byte element : a) {
            if ((element & 0xFF) <= 15) {
                result.append("0");
            }
            result.append(Integer.toHexString(element & 0xFF));
        }
        return result.toString();
    }

    public static enum AUTH_METHOD {
        PLAIN("PLAIN"),
        CRAM_MD5("CRAM-MD5"),
        LOGIN("LOGIN"),
        XOAUTH("XOAUTH"),
        XOAUTH2("XOAUTH2");

        private final String authName;

        private AUTH_METHOD(String name) {
            this.authName = name;
        }

        public final String getAuthName() {
            return this.authName;
        }
    }
}

