/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.services;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Profile;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.router.api.ProfileToImport;
import org.apache.unomi.router.api.services.ProfileImportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileImportServiceImpl
implements ProfileImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ProfileImportServiceImpl.class.getName());
    private PersistenceService persistenceService;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public boolean saveMergeDeleteImportedProfile(ProfileToImport profileToImport) throws InvocationTargetException, IllegalAccessException {
        LOGGER.debug("Importing profile with ID : {}", (Object)profileToImport.getItemId());
        Profile existingProfile = new Profile();
        if (profileToImport.getProperties().get(profileToImport.getMergingProperty()) != null) {
            List existingProfiles = this.persistenceService.query("properties." + profileToImport.getMergingProperty(), profileToImport.getProperties().get(profileToImport.getMergingProperty()).toString(), null, Profile.class);
            LOGGER.debug("Query existing profile with mergingProperty: {}. Found: {}", (Object)profileToImport.getMergingProperty(), (Object)existingProfiles.size());
            if (existingProfiles.size() == 1) {
                existingProfile = (Profile)existingProfiles.get(0);
                if (profileToImport.isProfileToDelete()) {
                    LOGGER.debug("Profile is to delete!");
                    this.persistenceService.remove(existingProfile.getItemId(), Profile.class);
                    return true;
                }
                List propertiesToOverwrite = profileToImport.getPropertiesToOverwrite();
                if (profileToImport.isOverwriteExistingProfiles() && propertiesToOverwrite != null && propertiesToOverwrite.size() > 0) {
                    LOGGER.debug("Properties to overwrite: {}", (Object)propertiesToOverwrite);
                    for (String propName : propertiesToOverwrite) {
                        existingProfile.getProperties().put(propName, profileToImport.getProperties().get(propName));
                    }
                } else {
                    LOGGER.debug("Overwrite all properties");
                    existingProfile.setProperties(profileToImport.getProperties());
                }
                existingProfile.setSegments(profileToImport.getSegments());
                existingProfile.setScores(profileToImport.getScores());
            } else if (existingProfiles.size() == 0 && !profileToImport.isProfileToDelete()) {
                LOGGER.debug("New profile to add...");
                BeanUtils.copyProperties((Object)existingProfile, (Object)profileToImport);
            } else {
                LOGGER.warn("{} occurrence(s) found for profile with {} = {}. Profile import is skipped", new Object[]{existingProfiles.size(), profileToImport.getMergingProperty(), profileToImport.getProperties().get(profileToImport.getMergingProperty()).toString()});
            }
            LOGGER.debug("-------------------------------------");
            if (!profileToImport.isProfileToDelete()) {
                return this.persistenceService.save((Item)existingProfile, true);
            }
            return false;
        }
        LOGGER.error("Merging property '{}' has no value in the current profile.", (Object)profileToImport.getMergingProperty());
        return false;
    }
}

