/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ExpressionToPredicateAdapter;

@Metadata(label="error")
@XmlRootElement(name="doCatch")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CatchDefinition
extends ProcessorDefinition<CatchDefinition> {
    @XmlElement(name="exception")
    private List<String> exceptions = new ArrayList<String>();
    @XmlElement(name="onWhen")
    @AsPredicate
    private WhenDefinition onWhen;
    @XmlElement(name="handled")
    @AsPredicate
    private ExpressionSubElementDefinition handled;
    @XmlElementRef
    private List<ProcessorDefinition<?>> outputs = new ArrayList();
    @XmlTransient
    private List<Class<? extends Throwable>> exceptionClasses;
    @XmlTransient
    private Predicate handledPolicy;

    public CatchDefinition() {
    }

    public CatchDefinition(List<Class<? extends Throwable>> exceptionClasses) {
        this.exceptionClasses = exceptionClasses;
    }

    public CatchDefinition(Class<? extends Throwable> exceptionType) {
        this.exceptionClasses = new ArrayList<Class<? extends Throwable>>();
        this.exceptionClasses.add(exceptionType);
    }

    public String toString() {
        return "DoCatch[ " + this.getExceptionClasses() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "doCatch";
    }

    @Override
    public String getLabel() {
        return "doCatch[ " + this.getExceptionClasses() + "]";
    }

    @Override
    public CatchProcessor createProcessor(RouteContext routeContext) throws Exception {
        if (this.exceptionClasses == null) {
            this.exceptionClasses = this.createExceptionClasses(routeContext.getCamelContext());
        }
        if (this.exceptionClasses.isEmpty()) {
            throw new IllegalArgumentException("At least one Exception must be configured to catch");
        }
        if (!(this.getParent() instanceof TryDefinition)) {
            throw new IllegalArgumentException("This doCatch should have a doTry as its parent on " + this);
        }
        Processor childProcessor = this.createChildProcessor(routeContext, false);
        Predicate when = null;
        if (this.onWhen != null) {
            when = this.onWhen.getExpression().createPredicate(routeContext);
        }
        Predicate handle = this.handledPolicy;
        if (this.handled != null) {
            handle = this.handled.createPredicate(routeContext);
        }
        return new CatchProcessor(this.exceptionClasses, childProcessor, when, handle);
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.outputs = outputs;
    }

    @Override
    public boolean isOutputSupported() {
        return true;
    }

    public List<Class<? extends Throwable>> getExceptionClasses() {
        return this.exceptionClasses;
    }

    public void setExceptionClasses(List<Class<? extends Throwable>> exceptionClasses) {
        this.exceptionClasses = exceptionClasses;
    }

    public CatchDefinition exceptionClasses(List<Class<? extends Throwable>> exceptionClasses) {
        this.setExceptionClasses(exceptionClasses);
        return this;
    }

    public CatchDefinition exception(Class<? extends Throwable> ... exceptions) {
        if (this.exceptionClasses == null) {
            this.exceptionClasses = new ArrayList<Class<? extends Throwable>>();
        }
        if (exceptions != null) {
            for (Class<? extends Throwable> exception : exceptions) {
                this.exceptionClasses.add(exception);
            }
        }
        return this;
    }

    public CatchDefinition onWhen(@AsPredicate Predicate predicate) {
        this.setOnWhen(new WhenDefinition(predicate));
        return this;
    }

    @Deprecated
    public CatchDefinition handled(boolean handled) {
        Expression expression = ExpressionBuilder.constantExpression(Boolean.toString(handled));
        return this.handled(expression);
    }

    @Deprecated
    public CatchDefinition handled(@AsPredicate Predicate handled) {
        this.setHandledPolicy(handled);
        return this;
    }

    @Deprecated
    public CatchDefinition handled(@AsPredicate Expression handled) {
        this.setHandledPolicy(ExpressionToPredicateAdapter.toPredicate(handled));
        return this;
    }

    public CatchDefinition exceptionClasses(Class<? extends Throwable> exception) {
        List<Class<? extends Throwable>> list = this.getExceptionClasses();
        list.add(exception);
        return this;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public WhenDefinition getOnWhen() {
        return this.onWhen;
    }

    public void setOnWhen(WhenDefinition onWhen) {
        this.onWhen = onWhen;
    }

    public Predicate getHandledPolicy() {
        return this.handledPolicy;
    }

    public void setHandledPolicy(Predicate handledPolicy) {
        this.handledPolicy = handledPolicy;
    }

    public ExpressionSubElementDefinition getHandled() {
        return this.handled;
    }

    public void setHandled(ExpressionSubElementDefinition handled) {
        this.handled = handled;
    }

    protected List<Class<? extends Throwable>> createExceptionClasses(CamelContext context) throws ClassNotFoundException {
        List<String> list = this.getExceptions();
        ArrayList<Class<? extends Throwable>> answer = new ArrayList<Class<? extends Throwable>>(list.size());
        for (String name : list) {
            Class<Throwable> type = context.getClassResolver().resolveMandatoryClass(name, Throwable.class);
            answer.add(type);
        }
        return answer;
    }
}

