/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.services.EventListenerService;
import org.apache.unomi.shell.commands.TailCommandSupport;

@Command(scope="unomi", name="event-tail", description="This will tail all the events coming into the Apache Unomi Context Server")
@Service
public class EventTail
extends TailCommandSupport {
    @Argument(index=0, name="withInternal", description="Whether to also monitor internal events (such as profileUpdated)", required=false, multiValued=false)
    boolean withInternal = false;
    int[] columnSizes = new int[]{36, 14, 36, 36, 29, 15, 5};
    String[] columnHeaders = new String[]{"ID", "Type", "Session", "Profile", "Timestamp", "Scope", "Persistent"};

    @Override
    public int[] getColumnSizes() {
        return this.columnSizes;
    }

    @Override
    public String[] getColumnHeaders() {
        return this.columnHeaders;
    }

    @Override
    public Object getListener() {
        return new TailEventListener(this.session.getConsole());
    }

    class TailEventListener
    implements EventListenerService {
        PrintStream out;

        public TailEventListener(PrintStream out) {
            this.out = out;
        }

        public boolean canHandle(Event event) {
            return true;
        }

        public int onEvent(Event event) {
            if (!event.isPersistent() && !EventTail.this.withInternal) {
                return 0;
            }
            ArrayList<String> eventInfo = new ArrayList<String>();
            eventInfo.add(event.getItemId());
            eventInfo.add(event.getEventType());
            eventInfo.add(event.getSessionId());
            eventInfo.add(event.getProfileId());
            eventInfo.add(event.getTimeStamp().toString());
            eventInfo.add(event.getScope());
            eventInfo.add(Boolean.toString(event.isPersistent()));
            EventTail.this.outputLine(this.out, eventInfo);
            return 0;
        }
    }
}

