/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;

public class XSLong
extends XSInteger {
    private static final String XS_LONG = "xs:long";

    public XSLong() {
        this(BigInteger.valueOf(0L));
    }

    public XSLong(BigInteger x) {
        super(x);
    }

    @Override
    public String string_type() {
        return XS_LONG;
    }

    @Override
    public String type_name() {
        return "long";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.string_value());
            BigInteger min = BigInteger.valueOf(Long.MIN_VALUE);
            BigInteger max = BigInteger.valueOf(Long.MAX_VALUE);
            if (bigInt.compareTo(min) < 0 || bigInt.compareTo(max) > 0) {
                DynamicError.throw_type_error();
            }
            rs.add(new XSLong(bigInt));
            return rs;
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }
}

