/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.processor.StaticChecker;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticAttrNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticElemNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticFunctNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticNsNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticTypeNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticVarNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AddExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AndExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AnyKindTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AttributeTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AxisStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.BinExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CastExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CastableExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CmpExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CntxItemExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CommentTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DecimalLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DivExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DocumentTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DoubleLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ElementTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ExceptExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.Expr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.FilterExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ForExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ForwardStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.FunctionCall;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IDivExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IfExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.InstOfExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IntegerLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IntersectExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ItemType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.MinusExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ModExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.MulExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.NameTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.NodeTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.OrExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PITest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ParExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PipeExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PlusExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.QuantifiedExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.RangeExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ReverseStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SchemaAttrTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SchemaElemTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SequenceType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SingleType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.StepExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.StringLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SubExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.TextTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.TreatAsExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.UnExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.UnionExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.VarExprPair;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.VarRef;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathVisitor;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;

public class StaticNameResolver
implements XPathVisitor,
StaticChecker {
    private StaticContext _sc;
    private StaticNameError _err;

    public StaticNameResolver(StaticContext sc) {
        this._sc = sc;
        this._err = null;
    }

    private void report_error(StaticNameError err) {
        this._err = err;
        throw new DummyError();
    }

    private void report_bad_prefix(String prefix) {
        this.report_error(StaticNsNameError.unknown_prefix(prefix));
    }

    @Override
    public void check(XPathNode node) throws StaticError {
        try {
            node.accept(this);
        }
        catch (DummyError e) {
            throw this._err;
        }
    }

    @Override
    public Object visit(XPath xp) {
        Iterator i = xp.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            e.accept(this);
        }
        return null;
    }

    private void doForExpr(Iterator iter, Expr expr) {
        int scopes = 0;
        while (iter.hasNext()) {
            VarExprPair pair = (VarExprPair)iter.next();
            QName var = pair.varname();
            if (!this._sc.expand_qname(var)) {
                this.report_bad_prefix(var.prefix());
            }
            Expr e = pair.expr();
            e.accept(this);
            this._sc.new_scope();
            ++scopes;
            this._sc.add_variable(var);
        }
        this._sc.new_scope();
        ++scopes;
        expr.accept(this);
        int i = 0;
        while (i < scopes) {
            this._sc.destroy_scope();
            ++i;
        }
    }

    @Override
    public Object visit(ForExpr fex) {
        this.doForExpr(fex.iterator(), fex.expr());
        return null;
    }

    @Override
    public Object visit(QuantifiedExpr qex) {
        this.doForExpr(qex.iterator(), qex.expr());
        return null;
    }

    private void printExprs(Iterator i) {
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            e.accept(this);
        }
    }

    @Override
    public Object visit(IfExpr ifex) {
        this.printExprs(ifex.iterator());
        ifex.then_clause().accept(this);
        ifex.else_clause().accept(this);
        return null;
    }

    public void printBinExpr(String name, BinExpr e) {
        e.left().accept(this);
        e.right().accept(this);
    }

    @Override
    public Object visit(OrExpr orex) {
        this.printBinExpr("OR", orex);
        return null;
    }

    @Override
    public Object visit(AndExpr andex) {
        this.printBinExpr("AND", andex);
        return null;
    }

    @Override
    public Object visit(CmpExpr cmpex) {
        this.printBinExpr("CMP" + cmpex.type(), cmpex);
        return null;
    }

    @Override
    public Object visit(RangeExpr rex) {
        this.printBinExpr("RANGE", rex);
        return null;
    }

    @Override
    public Object visit(AddExpr addex) {
        this.printBinExpr("ADD", addex);
        return null;
    }

    @Override
    public Object visit(SubExpr subex) {
        this.printBinExpr("SUB", subex);
        return null;
    }

    @Override
    public Object visit(MulExpr mulex) {
        this.printBinExpr("MUL", mulex);
        return null;
    }

    @Override
    public Object visit(DivExpr mulex) {
        this.printBinExpr("DIV", mulex);
        return null;
    }

    @Override
    public Object visit(IDivExpr mulex) {
        this.printBinExpr("IDIV", mulex);
        return null;
    }

    @Override
    public Object visit(ModExpr mulex) {
        this.printBinExpr("MOD", mulex);
        return null;
    }

    @Override
    public Object visit(UnionExpr unex) {
        this.printBinExpr("UNION", unex);
        return null;
    }

    @Override
    public Object visit(PipeExpr pipex) {
        this.printBinExpr("PIPE", pipex);
        return null;
    }

    @Override
    public Object visit(IntersectExpr iexpr) {
        this.printBinExpr("INTERSECT", iexpr);
        return null;
    }

    @Override
    public Object visit(ExceptExpr eexpr) {
        this.printBinExpr("INT_EXCEPT", eexpr);
        return null;
    }

    @Override
    public Object visit(InstOfExpr ioexp) {
        this.printBinExpr("INSTANCEOF", ioexp);
        return null;
    }

    @Override
    public Object visit(TreatAsExpr taexp) {
        this.printBinExpr("TREATAS", taexp);
        return null;
    }

    @Override
    public Object visit(CastableExpr cexp) {
        this.printBinExpr("CASTABLE", cexp);
        return null;
    }

    @Override
    public Object visit(CastExpr cexp) {
        this.printBinExpr("CAST", cexp);
        QName type = ((SingleType)cexp.right()).type();
        if (!this._sc.function_exists(type, 1)) {
            this.report_error(new StaticTypeNameError(null));
        }
        return null;
    }

    public void printUnExpr(String name, UnExpr e) {
        e.arg().accept(this);
    }

    @Override
    public Object visit(MinusExpr e) {
        this.printUnExpr("MINUS", e);
        return null;
    }

    @Override
    public Object visit(PlusExpr e) {
        this.printUnExpr("PLUS", e);
        return null;
    }

    @Override
    public Object visit(XPathExpr e) {
        XPathExpr xp = e;
        while (xp != null) {
            StepExpr se = xp.expr();
            if (se != null) {
                se.accept(this);
            }
            xp = xp.next();
        }
        return null;
    }

    @Override
    public Object visit(ForwardStep e) {
        e.node_test().accept(this);
        return null;
    }

    @Override
    public Object visit(ReverseStep e) {
        NodeTest nt = e.node_test();
        if (nt != null) {
            nt.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(NameTest e) {
        QName name = e.name();
        if (!this._sc.expand_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        return null;
    }

    @Override
    public Object visit(VarRef e) {
        QName var = e.name();
        if (!this._sc.expand_qname(var)) {
            this.report_bad_prefix(var.prefix());
        }
        if (!this._sc.variable_in_scope(var)) {
            this.report_error(new StaticVarNameError("Variable not in scope: " + var.string()));
        }
        return null;
    }

    @Override
    public Object visit(StringLiteral e) {
        return null;
    }

    @Override
    public Object visit(IntegerLiteral e) {
        return null;
    }

    @Override
    public Object visit(DoubleLiteral e) {
        return null;
    }

    @Override
    public Object visit(DecimalLiteral e) {
        return null;
    }

    @Override
    public Object visit(ParExpr e) {
        this.printExprs(e.iterator());
        return null;
    }

    @Override
    public Object visit(CntxItemExpr e) {
        return null;
    }

    @Override
    public Object visit(FunctionCall e) {
        QName name = e.name();
        if (!this._sc.expand_function_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        if (!this._sc.function_exists(name, e.arity())) {
            this.report_error(new StaticFunctNameError("Function does not exist: " + name.string() + " arity: " + e.arity()));
        }
        this.printExprs(e.iterator());
        return null;
    }

    @Override
    public Object visit(SingleType e) {
        QName type = e.type();
        if (!this._sc.expand_elem_type_qname(type)) {
            this.report_bad_prefix(type.prefix());
        }
        return null;
    }

    @Override
    public Object visit(SequenceType e) {
        ItemType it = e.item_type();
        if (it != null) {
            it.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(ItemType e) {
        switch (e.type()) {
            case 0: {
                break;
            }
            case 1: {
                QName type = e.qname();
                if (!this._sc.expand_elem_type_qname(type)) {
                    this.report_bad_prefix(type.prefix());
                }
                if (this._sc.type_defined(type) || this._sc.function_exists(type, 1)) break;
                this.report_error(new StaticTypeNameError("Type not defined: " + type.string()));
                break;
            }
            case 2: {
                e.kind_test().accept(this);
            }
        }
        return null;
    }

    @Override
    public Object visit(AnyKindTest e) {
        return null;
    }

    @Override
    public Object visit(DocumentTest e) {
        switch (e.type()) {
            case 1: {
                e.elem_test().accept(this);
                break;
            }
            case 2: {
                e.schema_elem_test().accept(this);
            }
        }
        return null;
    }

    @Override
    public Object visit(TextTest e) {
        return null;
    }

    @Override
    public Object visit(CommentTest e) {
        return null;
    }

    @Override
    public Object visit(PITest e) {
        String arg = e.arg();
        if (arg == null) {
            arg = "";
        }
        return null;
    }

    @Override
    public Object visit(AttributeTest e) {
        QName name = e.name();
        if (name == null) {
            return null;
        }
        if (!this._sc.expand_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        if ((name = e.type()) == null) {
            return null;
        }
        if (!this._sc.expand_elem_type_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        return null;
    }

    @Override
    public Object visit(SchemaAttrTest e) {
        QName name = e.arg();
        if (!this._sc.expand_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        if (!this._sc.attribute_declared(name)) {
            this.report_error(new StaticAttrNameError("Attribute not decleared: " + name.string()));
        }
        return null;
    }

    @Override
    public Object visit(ElementTest e) {
        QName name = e.name();
        if (name == null) {
            return null;
        }
        if (!this._sc.expand_elem_type_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        if ((name = e.type()) == null) {
            return null;
        }
        if (!this._sc.expand_elem_type_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        return null;
    }

    @Override
    public Object visit(SchemaElemTest e) {
        QName elem = e.name();
        if (!this._sc.expand_elem_type_qname(elem)) {
            this.report_bad_prefix(elem.prefix());
        }
        if (!this._sc.element_declared(elem)) {
            this.report_error(new StaticElemNameError("Element not declared: " + elem.string()));
        }
        return null;
    }

    private void printCollExprs(Iterator i) {
        while (i.hasNext()) {
            Collection exprs = (Collection)i.next();
            this.printExprs(exprs.iterator());
        }
    }

    @Override
    public Object visit(AxisStep e) {
        e.step().accept(this);
        this.printCollExprs(e.iterator());
        return null;
    }

    @Override
    public Object visit(FilterExpr e) {
        e.primary().accept(this);
        this.printCollExprs(e.iterator());
        return null;
    }

    static class DummyError
    extends Error {
        private static final long serialVersionUID = 3898564402981741950L;

        DummyError() {
        }
    }
}

