/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.objects.date.PyishDate;
import com.hubspot.jinjava.util.Logging;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(value="Pretty print a variable. Useful for debugging.", input={@JinjavaParam(value="value", type="object", desc="Object to Pretty Print", required=true)}, snippets={@JinjavaSnippet(code="{% set this_var =\"Variable that I want to debug\" %}\n{{ this_var|pprint }}")})
public class PrettyPrintFilter
implements Filter {
    @Override
    public String getName() {
        return "pprint";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        if (var == null) {
            return "null";
        }
        String varStr = null;
        varStr = var instanceof String || var instanceof Number || var instanceof PyishDate || var instanceof Iterable || var instanceof Map ? Objects.toString(var) : this.objPropsToString(var);
        return StringEscapeUtils.escapeHtml4((String)("{% raw %}(" + var.getClass().getSimpleName() + ": " + varStr + "){% endraw %}"));
    }

    private String objPropsToString(Object var) {
        LinkedList<String> props = new LinkedList<String>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(var.getClass());
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                try {
                    Method readMethod;
                    if (pd.getPropertyType() != null && pd.getPropertyType().equals(Class.class) || (readMethod = pd.getReadMethod()) == null || readMethod.getDeclaringClass().equals(Object.class)) continue;
                    props.add(pd.getName() + "=" + readMethod.invoke(var, new Object[0]));
                }
                catch (Exception e) {
                    Logging.ENGINE_LOG.error("Error reading bean value", (Throwable)e);
                }
            }
        }
        catch (IntrospectionException e) {
            Logging.ENGINE_LOG.error("Error inspecting bean", (Throwable)e);
        }
        return '{' + StringUtils.join(props, (String)", ") + '}';
    }
}

