/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;

public final class InnerClassProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final SettableBeanProperty _delegate;
    protected final transient Constructor<?> _creator;
    protected AnnotatedConstructor _annotated;

    public InnerClassProperty(SettableBeanProperty delegate, Constructor<?> ctor) {
        super(delegate);
        this._delegate = delegate;
        this._creator = ctor;
    }

    protected InnerClassProperty(InnerClassProperty src, AnnotatedConstructor ann) {
        super(src);
        this._delegate = src._delegate;
        this._annotated = ann;
        Constructor<?> constructor = this._creator = this._annotated == null ? null : this._annotated.getAnnotated();
        if (this._creator == null) {
            throw new IllegalArgumentException("Missing constructor (broken JDK (de)serialization?)");
        }
    }

    protected InnerClassProperty(InnerClassProperty src, JsonDeserializer<?> deser) {
        super((SettableBeanProperty)src, deser);
        this._delegate = src._delegate.withValueDeserializer(deser);
        this._creator = src._creator;
    }

    protected InnerClassProperty(InnerClassProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._delegate = src._delegate.withName(newName);
        this._creator = src._creator;
    }

    @Override
    public InnerClassProperty withName(PropertyName newName) {
        return new InnerClassProperty(this, newName);
    }

    @Override
    public InnerClassProperty withValueDeserializer(JsonDeserializer<?> deser) {
        return new InnerClassProperty(this, deser);
    }

    @Override
    public void assignIndex(int index) {
        this._delegate.assignIndex(index);
    }

    @Override
    public int getPropertyIndex() {
        return this._delegate.getPropertyIndex();
    }

    @Override
    public int getCreatorIndex() {
        return this._delegate.getCreatorIndex();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._delegate.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._delegate.getMember();
    }

    @Override
    public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object bean) throws IOException {
        Object value;
        JsonToken t2 = jp.getCurrentToken();
        if (t2 == JsonToken.VALUE_NULL) {
            value = this._valueDeserializer.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer != null) {
            value = this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer);
        } else {
            try {
                value = this._creator.newInstance(bean);
            }
            catch (Exception e) {
                ClassUtil.unwrapAndThrowAsIAE(e, "Failed to instantiate class " + this._creator.getDeclaringClass().getName() + ", problem: " + e.getMessage());
                value = null;
            }
            this._valueDeserializer.deserialize(jp, ctxt, value);
        }
        this.set(bean, value);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException {
        return this.setAndReturn(instance, this.deserialize(jp, ctxt));
    }

    @Override
    public final void set(Object instance, Object value) throws IOException {
        this._delegate.set(instance, value);
    }

    @Override
    public Object setAndReturn(Object instance, Object value) throws IOException {
        return this._delegate.setAndReturn(instance, value);
    }

    Object readResolve() {
        return new InnerClassProperty(this, this._annotated);
    }

    Object writeReplace() {
        if (this._annotated != null) {
            return this;
        }
        return new InnerClassProperty(this, new AnnotatedConstructor(null, this._creator, null, null));
    }
}

