/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava;

import com.hubspot.jinjava.el.JinjavaInterpreterResolver;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.InterpreterFactory;
import com.hubspot.jinjava.interpret.JinjavaInterpreterFactory;
import com.hubspot.jinjava.random.RandomNumberGeneratorStrategy;
import com.hubspot.jinjava.tree.parse.DefaultTokenScannerSymbols;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jinjava.javax.el.ELResolver;

public class JinjavaConfig {
    private final Charset charset;
    private final Locale locale;
    private final ZoneId timeZone;
    private final int maxRenderDepth;
    private final long maxOutputSize;
    private final boolean trimBlocks;
    private final boolean lstripBlocks;
    private final boolean enableRecursiveMacroCalls;
    private final int maxMacroRecursionDepth;
    private Map<Context.Library, Set<String>> disabled;
    private final boolean failOnUnknownTokens;
    private final boolean nestedInterpretationEnabled;
    private final RandomNumberGeneratorStrategy randomNumberGenerator;
    private final boolean validationMode;
    private final long maxStringLength;
    private InterpreterFactory interpreterFactory;
    private TokenScannerSymbols tokenScannerSymbols;
    private ELResolver elResolver;

    public static Builder newBuilder() {
        return new Builder();
    }

    public JinjavaConfig() {
        this(new JinjavaInterpreterFactory());
    }

    public JinjavaConfig(InterpreterFactory interpreterFactory) {
        this(StandardCharsets.UTF_8, Locale.ENGLISH, ZoneOffset.UTC, 10, new HashMap<Context.Library, Set<String>>(), false, false, false, 0, false, 0L, true, RandomNumberGeneratorStrategy.THREAD_LOCAL, false, 0L, interpreterFactory, new DefaultTokenScannerSymbols(), JinjavaInterpreterResolver.DEFAULT_RESOLVER_READ_ONLY);
    }

    public JinjavaConfig(Charset charset, Locale locale, ZoneId timeZone, int maxRenderDepth) {
        this(charset, locale, timeZone, maxRenderDepth, new HashMap<Context.Library, Set<String>>(), false, false, false, 0, false, 0L, true, RandomNumberGeneratorStrategy.THREAD_LOCAL, false, 0L, new JinjavaInterpreterFactory(), new DefaultTokenScannerSymbols(), JinjavaInterpreterResolver.DEFAULT_RESOLVER_READ_ONLY);
    }

    private JinjavaConfig(Charset charset, Locale locale, ZoneId timeZone, int maxRenderDepth, Map<Context.Library, Set<String>> disabled, boolean trimBlocks, boolean lstripBlocks, boolean enableRecursiveMacroCalls, int maxMacroRecursionDepth, boolean failOnUnknownTokens, long maxOutputSize, boolean nestedInterpretationEnabled, RandomNumberGeneratorStrategy randomNumberGenerator, boolean validationMode, long maxStringLength, InterpreterFactory interpreterFactory, TokenScannerSymbols tokenScannerSymbols, ELResolver elResolver) {
        this.charset = charset;
        this.locale = locale;
        this.timeZone = timeZone;
        this.maxRenderDepth = maxRenderDepth;
        this.disabled = disabled;
        this.trimBlocks = trimBlocks;
        this.lstripBlocks = lstripBlocks;
        this.enableRecursiveMacroCalls = enableRecursiveMacroCalls;
        this.maxMacroRecursionDepth = maxMacroRecursionDepth;
        this.failOnUnknownTokens = failOnUnknownTokens;
        this.maxOutputSize = maxOutputSize;
        this.nestedInterpretationEnabled = nestedInterpretationEnabled;
        this.randomNumberGenerator = randomNumberGenerator;
        this.validationMode = validationMode;
        this.maxStringLength = maxStringLength;
        this.interpreterFactory = interpreterFactory;
        this.tokenScannerSymbols = tokenScannerSymbols;
        this.elResolver = elResolver;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public int getMaxRenderDepth() {
        return this.maxRenderDepth;
    }

    public long getMaxOutputSize() {
        return this.maxOutputSize;
    }

    public RandomNumberGeneratorStrategy getRandomNumberGeneratorStrategy() {
        return this.randomNumberGenerator;
    }

    public boolean isTrimBlocks() {
        return this.trimBlocks;
    }

    public boolean isLstripBlocks() {
        return this.lstripBlocks;
    }

    public boolean isEnableRecursiveMacroCalls() {
        return this.enableRecursiveMacroCalls;
    }

    public int getMaxMacroRecursionDepth() {
        return this.maxMacroRecursionDepth;
    }

    public Map<Context.Library, Set<String>> getDisabled() {
        return this.disabled;
    }

    public boolean isFailOnUnknownTokens() {
        return this.failOnUnknownTokens;
    }

    public boolean isNestedInterpretationEnabled() {
        return this.nestedInterpretationEnabled;
    }

    public boolean isValidationMode() {
        return this.validationMode;
    }

    public long getMaxStringLength() {
        return this.maxStringLength;
    }

    public InterpreterFactory getInterpreterFactory() {
        return this.interpreterFactory;
    }

    public TokenScannerSymbols getTokenScannerSymbols() {
        return this.tokenScannerSymbols;
    }

    public void setTokenScannerSymbols(TokenScannerSymbols tokenScannerSymbols) {
        this.tokenScannerSymbols = tokenScannerSymbols;
    }

    public ELResolver getElResolver() {
        return this.elResolver;
    }

    public static class Builder {
        private Charset charset = StandardCharsets.UTF_8;
        private Locale locale = Locale.ENGLISH;
        private ZoneId timeZone = ZoneOffset.UTC;
        private int maxRenderDepth = 10;
        private long maxOutputSize = 0L;
        private Map<Context.Library, Set<String>> disabled = new HashMap<Context.Library, Set<String>>();
        private boolean trimBlocks;
        private boolean lstripBlocks;
        private boolean enableRecursiveMacroCalls;
        private int maxMacroRecursionDepth;
        private boolean failOnUnknownTokens;
        private boolean nestedInterpretationEnabled = true;
        private RandomNumberGeneratorStrategy randomNumberGeneratorStrategy = RandomNumberGeneratorStrategy.THREAD_LOCAL;
        private boolean validationMode = false;
        private long maxStringLength = 0L;
        private InterpreterFactory interpreterFactory = new JinjavaInterpreterFactory();
        private TokenScannerSymbols tokenScannerSymbols = new DefaultTokenScannerSymbols();
        private ELResolver elResolver = JinjavaInterpreterResolver.DEFAULT_RESOLVER_READ_ONLY;

        private Builder() {
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder withTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder withDisabled(Map<Context.Library, Set<String>> disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder withMaxRenderDepth(int maxRenderDepth) {
            this.maxRenderDepth = maxRenderDepth;
            return this;
        }

        public Builder withRandomNumberGeneratorStrategy(RandomNumberGeneratorStrategy randomNumberGeneratorStrategy) {
            this.randomNumberGeneratorStrategy = randomNumberGeneratorStrategy;
            return this;
        }

        public Builder withTrimBlocks(boolean trimBlocks) {
            this.trimBlocks = trimBlocks;
            return this;
        }

        public Builder withLstripBlocks(boolean lstripBlocks) {
            this.lstripBlocks = lstripBlocks;
            return this;
        }

        public Builder withEnableRecursiveMacroCalls(boolean enableRecursiveMacroCalls) {
            this.enableRecursiveMacroCalls = enableRecursiveMacroCalls;
            return this;
        }

        public Builder withMaxMacroRecursionDepth(int maxMacroRecursionDepth) {
            this.maxMacroRecursionDepth = maxMacroRecursionDepth;
            return this;
        }

        public Builder withReadOnlyResolver(boolean readOnlyResolver) {
            this.elResolver = readOnlyResolver ? JinjavaInterpreterResolver.DEFAULT_RESOLVER_READ_ONLY : JinjavaInterpreterResolver.DEFAULT_RESOLVER_READ_WRITE;
            return this;
        }

        public Builder withElResolver(ELResolver elResolver) {
            this.elResolver = elResolver;
            return this;
        }

        public Builder withFailOnUnknownTokens(boolean failOnUnknownTokens) {
            this.failOnUnknownTokens = failOnUnknownTokens;
            return this;
        }

        public Builder withMaxOutputSize(long maxOutputSize) {
            this.maxOutputSize = maxOutputSize;
            return this;
        }

        public Builder withNestedInterpretationEnabled(boolean nestedInterpretationEnabled) {
            this.nestedInterpretationEnabled = nestedInterpretationEnabled;
            return this;
        }

        public Builder withValidationMode(boolean validationMode) {
            this.validationMode = validationMode;
            return this;
        }

        public Builder withMaxStringLength(long maxStringLength) {
            this.maxStringLength = maxStringLength;
            return this;
        }

        public Builder withInterperterFactory(InterpreterFactory interperterFactory) {
            this.interpreterFactory = interperterFactory;
            return this;
        }

        public Builder withTokenScannerSymbols(TokenScannerSymbols tokenScannerSymbols) {
            this.tokenScannerSymbols = tokenScannerSymbols;
            return this;
        }

        public JinjavaConfig build() {
            return new JinjavaConfig(this.charset, this.locale, this.timeZone, this.maxRenderDepth, this.disabled, this.trimBlocks, this.lstripBlocks, this.enableRecursiveMacroCalls, this.maxMacroRecursionDepth, this.failOnUnknownTokens, this.maxOutputSize, this.nestedInterpretationEnabled, this.randomNumberGeneratorStrategy, this.validationMode, this.maxStringLength, this.interpreterFactory, this.tokenScannerSymbols, this.elResolver);
        }
    }
}

