/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.date;

import com.hubspot.jinjava.objects.PyWrapper;
import com.hubspot.jinjava.objects.date.StrftimeFormatter;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;

public final class PyishDate
extends Date
implements Serializable,
PyWrapper {
    private static final long serialVersionUID = 1L;
    private final ZonedDateTime date;

    public PyishDate(ZonedDateTime dt) {
        super(dt.toInstant().toEpochMilli());
        this.date = dt;
    }

    public PyishDate(Date d) {
        this(ZonedDateTime.ofInstant(d.toInstant(), ZoneOffset.UTC));
    }

    public PyishDate(String publishDateStr) {
        this((Long)NumberUtils.toLong(Objects.requireNonNull(publishDateStr), 0L));
    }

    public PyishDate(Long epochMillis) {
        this(ZonedDateTime.ofInstant(Instant.ofEpochMilli(Optional.ofNullable(epochMillis).orElseGet(System::currentTimeMillis)), ZoneOffset.UTC));
    }

    public PyishDate(Instant instant) {
        this(ZonedDateTime.ofInstant(instant, ZoneOffset.UTC));
    }

    public String isoformat() {
        return this.strftime("yyyy-MM-dd");
    }

    public String strftime(String fmt) {
        return StrftimeFormatter.format(this.date, fmt);
    }

    @Override
    public int getYear() {
        return this.date.getYear();
    }

    @Override
    public int getMonth() {
        return this.date.getMonthValue();
    }

    @Override
    public int getDay() {
        return this.date.getDayOfMonth();
    }

    public int getHour() {
        return this.date.getHour();
    }

    public int getMinute() {
        return this.date.getMinute();
    }

    public int getSecond() {
        return this.date.getSecond();
    }

    public int getMicrosecond() {
        return this.date.get(ChronoField.MILLI_OF_SECOND);
    }

    public Date toDate() {
        return Date.from(this.date.toInstant());
    }

    public ZonedDateTime toDateTime() {
        return this.date;
    }

    @Override
    public String toString() {
        return this.strftime("yyyy-MM-dd HH:mm:ss");
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.date);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PyishDate that = (PyishDate)obj;
        return Objects.equals(this.toDateTime(), that.toDateTime());
    }
}

