/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.hubspot.jinjava.interpret.InterpretException;

public final class WhitespaceUtils {
    public static boolean startsWith(String s2, String prefix) {
        if (s2 == null) {
            return false;
        }
        for (int i = 0; i < s2.length(); ++i) {
            if (Character.isWhitespace(s2.charAt(i))) continue;
            return s2.regionMatches(i, prefix, 0, prefix.length());
        }
        return false;
    }

    public static boolean endsWith(String s2, String suffix) {
        if (s2 == null) {
            return false;
        }
        for (int i = s2.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(s2.charAt(i))) continue;
            return s2.regionMatches(i - suffix.length() + 1, suffix, 0, suffix.length());
        }
        return false;
    }

    public static boolean isWrappedWith(String s2, String prefix, String suffix) {
        return WhitespaceUtils.startsWith(s2, prefix) && WhitespaceUtils.endsWith(s2, suffix);
    }

    public static boolean isQuoted(String s2) {
        if (WhitespaceUtils.startsWith(s2, "'")) {
            if (!WhitespaceUtils.endsWith(s2, "'")) {
                throw new InterpretException("Unbalanced quotes: " + s2);
            }
            return true;
        }
        if (WhitespaceUtils.startsWith(s2, "\"")) {
            if (!WhitespaceUtils.endsWith(s2, "\"")) {
                throw new InterpretException("Unbalanced quotes: " + s2);
            }
            return true;
        }
        return false;
    }

    public static String unquote(String s2) {
        if (s2 == null) {
            return "";
        }
        if (WhitespaceUtils.startsWith(s2, "'")) {
            return WhitespaceUtils.unwrap(s2, "'", "'");
        }
        if (WhitespaceUtils.startsWith(s2, "\"")) {
            return WhitespaceUtils.unwrap(s2, "\"", "\"");
        }
        return s2.trim();
    }

    public static String unwrap(String s2, String prefix, String suffix) {
        int start;
        int end = s2.length() - 1;
        for (start = 0; start < s2.length() && Character.isWhitespace(s2.charAt(start)); ++start) {
        }
        while (end >= 0 && Character.isWhitespace(s2.charAt(end))) {
            --end;
        }
        return s2.substring(start + prefix.length(), end - suffix.length() + 1);
    }

    private WhitespaceUtils() {
    }
}

