/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter.com.google.common.base;

import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.apache.zeppelin.jupyter.com.google.common.annotations.Beta;
import org.apache.zeppelin.jupyter.com.google.common.annotations.GwtCompatible;
import org.apache.zeppelin.jupyter.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.apache.zeppelin.jupyter.com.google.common.base.Equivalence;
import org.apache.zeppelin.jupyter.com.google.common.base.Function;
import org.apache.zeppelin.jupyter.com.google.common.base.Objects;
import org.apache.zeppelin.jupyter.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible
final class FunctionalEquivalence<F, T>
extends Equivalence<F>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Function<? super F, ? extends @Nullable T> function;
    private final Equivalence<T> resultEquivalence;

    FunctionalEquivalence(Function<? super F, ? extends @Nullable T> function, Equivalence<T> resultEquivalence) {
        this.function = Preconditions.checkNotNull(function);
        this.resultEquivalence = Preconditions.checkNotNull(resultEquivalence);
    }

    @Override
    protected boolean doEquivalent(F a, F b) {
        return this.resultEquivalence.equivalent(this.function.apply(a), this.function.apply(b));
    }

    @Override
    protected int doHash(F a) {
        return this.resultEquivalence.hash(this.function.apply(a));
    }

    public boolean equals(@CheckForNull Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FunctionalEquivalence) {
            FunctionalEquivalence that = (FunctionalEquivalence)obj;
            return this.function.equals(that.function) && this.resultEquivalence.equals(that.resultEquivalence);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.function, this.resultEquivalence);
    }

    public String toString() {
        String string = String.valueOf(this.resultEquivalence);
        String string2 = String.valueOf(this.function);
        return new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".onResultOf(").append(string2).append(")").toString();
    }
}

