/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.submarine;

import java.util.Properties;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.shell.ShellInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmarineShellInterpreter
extends ShellInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubmarineShellInterpreter.class);
    private final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private final String shell = this.isWindows ? "cmd /c" : "bash -c";

    public SubmarineShellInterpreter(Properties property) {
        super(property);
    }

    @Override
    public InterpreterResult internalInterpret(String cmd, InterpreterContext context) {
        String checkpointPath;
        this.setParagraphConfig(context);
        String algorithmPath = this.properties.getProperty("submarine.algorithm.hdfs.path", "");
        if (algorithmPath.contains("${username}")) {
            algorithmPath = algorithmPath.replace("${username}", this.userName);
            this.properties.setProperty("submarine.algorithm.hdfs.path", algorithmPath);
        }
        if ((checkpointPath = this.properties.getProperty("tf.checkpoint.path", "")).contains("${username}")) {
            checkpointPath = checkpointPath.replace("${username}", this.userName);
            this.properties.setProperty("tf.checkpoint.path", checkpointPath);
        }
        return super.internalInterpret(cmd, context);
    }

    private void setParagraphConfig(InterpreterContext context) {
        context.getConfig().put("editorHide", false);
        context.getConfig().put("title", true);
    }

    @Override
    protected boolean runKerberosLogin() {
        try {
            this.createSecureConfiguration();
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Unable to run kinit for zeppelin", e);
            return false;
        }
    }

    @Override
    public void createSecureConfiguration() throws InterpreterException {
        Properties properties = this.getProperties();
        CommandLine cmdLine = CommandLine.parse(this.shell);
        cmdLine.addArgument("-c", false);
        String kinitCommand = String.format("kinit -k -t %s %s", properties.getProperty("SUBMARINE_HADOOP_KEYTAB"), properties.getProperty("SUBMARINE_HADOOP_PRINCIPAL"));
        cmdLine.addArgument(kinitCommand, false);
        DefaultExecutor executor = new DefaultExecutor();
        try {
            executor.execute(cmdLine);
        }
        catch (Exception e) {
            LOGGER.error("Unable to run kinit for zeppelin user " + kinitCommand, e);
            throw new InterpreterException((Throwable)e);
        }
    }

    @Override
    protected boolean isKerboseEnabled() {
        String authType = this.getProperty("zeppelin.submarine.auth.type", "");
        return StringUtils.equals(authType, "kerberos");
    }
}

