/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.submarine.job.thread;

import com.google.common.io.Resources;
import com.hubspot.jinjava.Jinjava;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.submarine.commons.SubmarineUI;
import org.apache.zeppelin.submarine.commons.SubmarineUtils;
import org.apache.zeppelin.submarine.hadoop.HdfsClient;
import org.apache.zeppelin.submarine.job.SubmarineJob;
import org.apache.zeppelin.submarine.job.SubmarineJobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunThread
extends Thread {
    private Logger LOGGER = LoggerFactory.getLogger(JobRunThread.class);
    private SubmarineJob submarineJob;
    private AtomicBoolean running = new AtomicBoolean(false);
    private Lock lockRunning = new ReentrantLock();

    public JobRunThread(SubmarineJob submarineJob) {
        this.submarineJob = submarineJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean tryLock = this.lockRunning.tryLock();
        if (!tryLock) {
            this.LOGGER.warn("Can not get JobRunThread lockRunning!");
            return;
        }
        final SubmarineUI submarineUI = this.submarineJob.getSubmarineUI();
        try {
            InterpreterContext intpContext = this.submarineJob.getIntpContext();
            String noteId = intpContext.getNoteId();
            String userName = intpContext.getAuthenticationInfo().getUser();
            final String jobName = SubmarineUtils.getJobName(userName, noteId);
            if (this.running.get()) {
                String message = String.format("Job %s already running.", jobName);
                submarineUI.outputLog("WARN", message);
                this.LOGGER.warn(message);
                return;
            }
            this.running.set(true);
            Properties properties = this.submarineJob.getProperties();
            HdfsClient hdfsClient = this.submarineJob.getHdfsClient();
            File pythonWorkDir = this.submarineJob.getPythonWorkDir();
            this.submarineJob.setCurrentJobState(SubmarineJobStatus.EXECUTE_SUBMARINE);
            String algorithmPath = properties.getProperty("submarine.algorithm.hdfs.path", "");
            if (!algorithmPath.startsWith("hdfs://")) {
                String message = "Algorithm file upload HDFS path, Must be `hdfs://` prefix. now setting " + algorithmPath;
                submarineUI.outputLog("Configuration error", message);
                return;
            }
            List paragraphInfos = intpContext.getIntpEventClient().getParagraphList(userName, noteId);
            String outputMsg = hdfsClient.saveParagraphToFiles(noteId, paragraphInfos, pythonWorkDir == null ? "" : pythonWorkDir.getAbsolutePath(), properties);
            if (!StringUtils.isEmpty(outputMsg)) {
                submarineUI.outputLog("Save algorithm file", outputMsg);
            }
            HashMap jinjaParams = SubmarineUtils.propertiesToJinjaParams(properties, this.submarineJob, true);
            Jinjava jinjava = new Jinjava();
            URL urlTemplate = Resources.getResource("jinja_templates/submarine-job-run-tf.jinja");
            String template = Resources.toString(urlTemplate, Charsets.UTF_8);
            String submarineCmd = jinjava.render(template, jinjaParams);
            int firstLineIsNewline = submarineCmd.indexOf("\n");
            if (firstLineIsNewline == 0) {
                submarineCmd = submarineCmd.replaceFirst("\n", "");
            }
            StringBuffer sbLogs = new StringBuffer(submarineCmd);
            submarineUI.outputLog("Submarine submit command", sbLogs.toString());
            long timeout = Long.valueOf(properties.getProperty("submarine.command.timeout.millisecond", "100000"));
            CommandLine cmdLine = CommandLine.parse(SubmarineJob.shell);
            cmdLine.addArgument(submarineCmd, false);
            DefaultExecutor executor = new DefaultExecutor();
            ExecuteWatchdog watchDog = new ExecuteWatchdog(timeout);
            executor.setWatchdog(watchDog);
            final StringBuffer sbLogOutput = new StringBuffer();
            executor.setStreamHandler(new PumpStreamHandler(new LogOutputStream(){

                @Override
                protected void processLine(String line, int level) {
                    if (!StringUtils.isEmpty(line = line.trim())) {
                        sbLogOutput.append(line + "\n");
                    }
                }
            }));
            if (Boolean.valueOf(properties.getProperty("shell.working.directory.userName.home")).booleanValue()) {
                executor.setWorkingDirectory(new File(System.getProperty("user.home")));
            }
            HashMap<String, String> env = new HashMap<String, String>();
            String launchMode = (String)jinjaParams.get("INTERPRETER_LAUNCH_MODE");
            if (StringUtils.equals(launchMode, "yarn")) {
                String javaHome = (String)jinjaParams.get("DOCKER_JAVA_HOME");
                String hadoopHome = (String)jinjaParams.get("DOCKER_HADOOP_HDFS_HOME");
                String hadoopConf = (String)jinjaParams.get("SUBMARINE_HADOOP_CONF_DIR");
                env.put("JAVA_HOME", javaHome);
                env.put("HADOOP_HOME", hadoopHome);
                env.put("HADOOP_HDFS_HOME", hadoopHome);
                env.put("HADOOP_CONF_DIR", hadoopConf);
                env.put("YARN_CONF_DIR", hadoopConf);
                env.put("CLASSPATH", "`$HADOOP_HDFS_HOME/bin/hadoop classpath --glob`");
                env.put("ZEPPELIN_FORCE_STOP", "true");
            }
            this.LOGGER.info("Execute EVN: {}, Command: {} ", (Object)((Object)env).toString(), (Object)submarineCmd);
            final AtomicBoolean cmdLineRunning = new AtomicBoolean(true);
            executor.execute(cmdLine, env, new DefaultExecuteResultHandler(){

                @Override
                public void onProcessComplete(int exitValue) {
                    String message = String.format("jobName %s ProcessComplete exit value is : %d", jobName, exitValue);
                    JobRunThread.this.LOGGER.info(message);
                    submarineUI.outputLog("JOR RUN COMPLETE", message);
                    cmdLineRunning.set(false);
                    JobRunThread.this.submarineJob.setCurrentJobState(SubmarineJobStatus.EXECUTE_SUBMARINE_FINISHED);
                }

                @Override
                public void onProcessFailed(ExecuteException e) {
                    String message = String.format("jobName %s ProcessFailed exit value is : %d, exception is : %s", jobName, e.getExitValue(), e.getMessage());
                    JobRunThread.this.LOGGER.error(message);
                    submarineUI.outputLog("JOR RUN FAILED", message);
                    cmdLineRunning.set(false);
                    JobRunThread.this.submarineJob.setCurrentJobState(SubmarineJobStatus.EXECUTE_SUBMARINE_ERROR);
                }
            });
            int loopCount = 100;
            while (loopCount-- > 0 && cmdLineRunning.get() && this.running.get()) {
                Thread.sleep(1000L);
            }
            if (watchDog.isWatching()) {
                watchDog.destroyProcess();
                Thread.sleep(1000L);
            }
            if (watchDog.isWatching()) {
                watchDog.killedProcess();
            }
            Map<String, Object> jobState = this.submarineJob.getJobStateByYarn(jobName);
            loopCount = 50;
            while (loopCount-- > 0 && !jobState.containsKey("state") && this.running.get()) {
                Thread.sleep(3000L);
                jobState = this.submarineJob.getJobStateByYarn(jobName);
            }
            if (!jobState.containsKey("state")) {
                String message = String.format("JOB %s was not submitted to YARN!", jobName);
                this.LOGGER.error(message);
                submarineUI.outputLog("JOR RUN FAILED", message);
                this.submarineJob.setCurrentJobState(SubmarineJobStatus.EXECUTE_SUBMARINE_ERROR);
            }
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), e);
            this.submarineJob.setCurrentJobState(SubmarineJobStatus.EXECUTE_SUBMARINE_ERROR);
            submarineUI.outputLog("Exception", e.getMessage());
        }
        finally {
            this.running.set(false);
            this.lockRunning.unlock();
        }
    }

    public void stopRunning() {
        try {
            this.running.set(false);
            boolean tryLock = this.lockRunning.tryLock();
            int loop = 0;
            while (!tryLock && loop++ < 100) {
                this.LOGGER.warn("Can not get the JobRunThread lockRunning [{}] !", (Object)loop);
                Thread.sleep(500L);
                tryLock = this.lockRunning.tryLock();
            }
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), e);
        }
        finally {
            this.lockRunning.unlock();
        }
    }
}

