/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.file;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileInterpreter
extends Interpreter {
    Logger logger = LoggerFactory.getLogger(FileInterpreter.class);
    String currentDir = new String("/");
    CommandArgs args = null;

    public FileInterpreter(Properties property) {
        super(property);
    }

    public abstract String listAll(String var1) throws InterpreterException;

    public abstract boolean isDirectory(String var1);

    protected String getNewPath(String argument) {
        Path arg = Paths.get(argument, new String[0]);
        Path ret = arg.isAbsolute() ? arg : Paths.get(this.currentDir, argument);
        return ret.normalize().toString();
    }

    public InterpreterResult interpret(String cmd, InterpreterContext contextInterpreter) {
        this.logger.info("Run File command '" + cmd + "'");
        this.args = new CommandArgs(cmd);
        this.args.parseArgs();
        if (this.args.command == null) {
            this.logger.info("Error: No command");
            return new InterpreterResult(InterpreterResult.Code.ERROR, InterpreterResult.Type.TEXT, "No command");
        }
        if (this.args.command.equals("cd")) {
            String newPath;
            String string = newPath = !this.args.args.isEmpty() ? this.getNewPath(this.args.args.get(0)) : this.currentDir;
            if (!this.isDirectory(newPath)) {
                return new InterpreterResult(InterpreterResult.Code.ERROR, InterpreterResult.Type.TEXT, newPath + ": No such directory");
            }
            this.currentDir = newPath;
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.TEXT, "OK");
        }
        if (this.args.command.equals("ls")) {
            String newPath = !this.args.args.isEmpty() ? this.getNewPath(this.args.args.get(0)) : this.currentDir;
            try {
                String results = this.listAll(newPath);
                return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.TEXT, results);
            }
            catch (Exception e) {
                this.logger.error("Error listing files in path " + newPath, e);
                return new InterpreterResult(InterpreterResult.Code.ERROR, InterpreterResult.Type.TEXT, e.getMessage());
            }
        }
        if (this.args.command.equals("pwd")) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.TEXT, this.currentDir);
        }
        return new InterpreterResult(InterpreterResult.Code.ERROR, InterpreterResult.Type.TEXT, "Unknown command");
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(FileInterpreter.class.getName() + ((Object)((Object)this)).hashCode());
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return null;
    }

    public class CommandArgs {
        public String input = null;
        public String command = null;
        public ArrayList<String> args = null;
        public HashSet<Character> flags = null;

        public CommandArgs(String cmd) {
            this.input = cmd;
            this.args = new ArrayList();
            this.flags = new HashSet();
        }

        private void parseArg(String arg) {
            if (arg.charAt(0) == '-') {
                for (int i = 0; i < arg.length(); ++i) {
                    Character c = Character.valueOf(arg.charAt(i));
                    this.flags.add(c);
                }
            } else {
                this.args.add(arg);
            }
        }

        public void parseArgs() {
            if (this.input == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(this.input);
            if (st.hasMoreTokens()) {
                this.command = st.nextToken();
                while (st.hasMoreTokens()) {
                    this.parseArg(st.nextToken());
                }
            }
        }
    }
}

