/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import io.atomix.core.map.AsyncAtomicCounterMap;
import io.atomix.core.map.AtomicCounterMap;
import io.atomix.core.map.impl.AtomicCounterMapService;
import io.atomix.core.map.impl.BlockingAtomicCounterMap;
import io.atomix.primitive.AbstractAsyncPrimitive;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.proxy.ProxyClient;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public class AtomicCounterMapProxy
extends AbstractAsyncPrimitive<AsyncAtomicCounterMap<String>, AtomicCounterMapService>
implements AsyncAtomicCounterMap<String> {
    public AtomicCounterMapProxy(ProxyClient<AtomicCounterMapService> proxy, PrimitiveRegistry registry) {
        super(proxy, registry);
    }

    @Override
    public CompletableFuture<Long> incrementAndGet(String key) {
        return this.getProxyClient().applyBy(key, service -> service.incrementAndGet(key));
    }

    @Override
    public CompletableFuture<Long> decrementAndGet(String key) {
        return this.getProxyClient().applyBy(key, service -> service.decrementAndGet(key));
    }

    @Override
    public CompletableFuture<Long> getAndIncrement(String key) {
        return this.getProxyClient().applyBy(key, service -> service.getAndIncrement(key));
    }

    @Override
    public CompletableFuture<Long> getAndDecrement(String key) {
        return this.getProxyClient().applyBy(key, service -> service.getAndDecrement(key));
    }

    @Override
    public CompletableFuture<Long> addAndGet(String key, long delta) {
        return this.getProxyClient().applyBy(key, service -> service.addAndGet(key, delta));
    }

    @Override
    public CompletableFuture<Long> getAndAdd(String key, long delta) {
        return this.getProxyClient().applyBy(key, service -> service.getAndAdd(key, delta));
    }

    @Override
    public CompletableFuture<Long> get(String key) {
        return this.getProxyClient().applyBy(key, service -> service.get(key));
    }

    @Override
    public CompletableFuture<Long> put(String key, long newValue) {
        return this.getProxyClient().applyBy(key, service -> service.put(key, newValue));
    }

    @Override
    public CompletableFuture<Long> putIfAbsent(String key, long newValue) {
        return this.getProxyClient().applyBy(key, service -> service.putIfAbsent(key, newValue));
    }

    @Override
    public CompletableFuture<Boolean> replace(String key, long expectedOldValue, long newValue) {
        return this.getProxyClient().applyBy(key, service -> service.replace(key, expectedOldValue, newValue));
    }

    @Override
    public CompletableFuture<Long> remove(String key) {
        return this.getProxyClient().applyBy(key, service -> service.remove(key));
    }

    @Override
    public CompletableFuture<Boolean> remove(String key, long value) {
        return this.getProxyClient().applyBy(key, service -> service.remove(key, value));
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.getProxyClient().applyAll(service -> service.isEmpty()).thenApply(results -> results.allMatch(Predicate.isEqual(true)));
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.getProxyClient().applyAll(service -> service.size()).thenApply(results -> results.reduce(Math::addExact).orElse(0));
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.getProxyClient().acceptAll(service -> service.clear());
    }

    @Override
    public AtomicCounterMap<String> sync(Duration operationTimeout) {
        return new BlockingAtomicCounterMap<String>(this, operationTimeout.toMillis());
    }
}

