/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import io.atomix.core.map.AsyncDistributedSortedMap;
import io.atomix.core.map.DistributedSortedMap;
import io.atomix.core.map.DistributedSortedMapBuilder;
import io.atomix.core.map.DistributedSortedMapConfig;
import io.atomix.core.map.impl.AtomicNavigableMapProxy;
import io.atomix.core.map.impl.AtomicTreeMapService;
import io.atomix.core.map.impl.DelegatingAsyncDistributedSortedMap;
import io.atomix.core.map.impl.GossipDistributedSortedMap;
import io.atomix.core.map.impl.TranscodingAsyncAtomicNavigableMap;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.protocol.GossipProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.map.SortedMapProtocol;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;

public class DefaultDistributedSortedMapBuilder<K extends Comparable<K>, V>
extends DistributedSortedMapBuilder<K, V> {
    public DefaultDistributedSortedMapBuilder(String name, DistributedSortedMapConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<DistributedSortedMap<K, V>> buildAsync() {
        PrimitiveProtocol protocol = this.protocol();
        if (protocol instanceof GossipProtocol) {
            if (protocol instanceof SortedMapProtocol) {
                return this.managementService.getPrimitiveCache().getPrimitive(this.name, () -> CompletableFuture.completedFuture(((SortedMapProtocol)protocol).newSortedMapDelegate(this.name, this.serializer(), this.managementService)).thenApply(set -> new GossipDistributedSortedMap(this.name, protocol, set))).thenApply(AsyncDistributedSortedMap::sync);
            }
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException("Sets are not supported by the provided gossip protocol"));
        }
        return ((CompletableFuture)((CompletableFuture)this.newProxy(AtomicTreeMapService.class, new ServiceConfig()).thenCompose(proxy -> new AtomicNavigableMapProxy(proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(map -> {
            Serializer serializer = this.serializer();
            return new TranscodingAsyncAtomicNavigableMap(map, value -> serializer.encode(value), bytes -> serializer.decode(bytes));
        })).thenApply(atomicMap -> new DelegatingAsyncDistributedSortedMap(atomicMap).sync());
    }
}

