/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import io.atomix.core.map.AsyncAtomicCounterMap;
import io.atomix.core.map.AtomicCounterMap;
import io.atomix.core.map.impl.BlockingAtomicCounterMap;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.utils.concurrent.Futures;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class TranscodingAsyncAtomicCounterMap<K1, K2>
extends DelegatingAsyncPrimitive
implements AsyncAtomicCounterMap<K1> {
    private final AsyncAtomicCounterMap<K2> backingMap;
    private final Function<K1, K2> keyEncoder;
    private final Function<K2, K1> keyDecoder;

    public TranscodingAsyncAtomicCounterMap(AsyncAtomicCounterMap<K2> backingMap, Function<K1, K2> keyEncoder, Function<K2, K1> keyDecoder) {
        super(backingMap);
        this.backingMap = backingMap;
        this.keyEncoder = k -> k == null ? null : keyEncoder.apply(k);
        this.keyDecoder = k -> k == null ? null : keyDecoder.apply(k);
    }

    @Override
    public CompletableFuture<Long> incrementAndGet(K1 key) {
        try {
            return this.backingMap.incrementAndGet(this.keyEncoder.apply(key));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Long> decrementAndGet(K1 key) {
        try {
            return this.backingMap.decrementAndGet(this.keyEncoder.apply(key));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Long> getAndIncrement(K1 key) {
        try {
            return this.backingMap.getAndIncrement(this.keyEncoder.apply(key));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Long> getAndDecrement(K1 key) {
        try {
            return this.backingMap.getAndDecrement(this.keyEncoder.apply(key));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Long> addAndGet(K1 key, long delta) {
        try {
            return this.backingMap.addAndGet(this.keyEncoder.apply(key), delta);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Long> getAndAdd(K1 key, long delta) {
        try {
            return this.backingMap.getAndAdd(this.keyEncoder.apply(key), delta);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Long> get(K1 key) {
        try {
            return this.backingMap.get(this.keyEncoder.apply(key));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Long> put(K1 key, long newValue) {
        try {
            return this.backingMap.put(this.keyEncoder.apply(key), newValue);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Long> putIfAbsent(K1 key, long newValue) {
        try {
            return this.backingMap.putIfAbsent(this.keyEncoder.apply(key), newValue);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> replace(K1 key, long expectedOldValue, long newValue) {
        try {
            return this.backingMap.replace(this.keyEncoder.apply(key), expectedOldValue, newValue);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Long> remove(K1 key) {
        try {
            return this.backingMap.remove(this.keyEncoder.apply(key));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> remove(K1 key, long value) {
        try {
            return this.backingMap.remove(this.keyEncoder.apply(key), value);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Integer> size() {
        try {
            return this.backingMap.size();
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        try {
            return this.backingMap.isEmpty();
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> clear() {
        try {
            return this.backingMap.clear();
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public AtomicCounterMap<K1> sync(Duration operationTimeout) {
        return new BlockingAtomicCounterMap(this, operationTimeout.toMillis());
    }
}

