/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree.impl;

import com.google.common.base.Throwables;
import io.atomix.core.tree.AsyncAtomicDocumentTree;
import io.atomix.core.tree.AtomicDocumentTree;
import io.atomix.core.tree.DocumentException;
import io.atomix.core.tree.DocumentPath;
import io.atomix.core.tree.DocumentTreeEventListener;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import io.atomix.utils.time.Versioned;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingAtomicDocumentTree<V>
extends Synchronous<AsyncAtomicDocumentTree<V>>
implements AtomicDocumentTree<V> {
    private final AsyncAtomicDocumentTree<V> backingTree;
    private final long operationTimeoutMillis;

    public BlockingAtomicDocumentTree(AsyncAtomicDocumentTree<V> backingTree, long operationTimeoutMillis) {
        super(backingTree);
        this.backingTree = backingTree;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public DocumentPath root() {
        return this.backingTree.root();
    }

    @Override
    public Map<String, Versioned<V>> getChildren(DocumentPath path) {
        return this.complete(this.backingTree.getChildren(path));
    }

    @Override
    public Versioned<V> get(DocumentPath path) {
        return this.complete(this.backingTree.get(path));
    }

    @Override
    public Versioned<V> set(DocumentPath path, V value) {
        return this.complete(this.backingTree.set(path, value));
    }

    @Override
    public boolean create(DocumentPath path, V value) {
        return this.complete(this.backingTree.create(path, value));
    }

    @Override
    public boolean createRecursive(DocumentPath path, V value) {
        return this.complete(this.backingTree.createRecursive(path, value));
    }

    @Override
    public boolean replace(DocumentPath path, V newValue, long version) {
        return this.complete(this.backingTree.replace(path, (long)newValue, version));
    }

    @Override
    public boolean replace(DocumentPath path, V newValue, V currentValue) {
        return this.complete(this.backingTree.replace(path, newValue, currentValue));
    }

    @Override
    public Versioned<V> removeNode(DocumentPath path) {
        return this.complete(this.backingTree.removeNode(path));
    }

    @Override
    public void addListener(DocumentPath path, DocumentTreeEventListener<V> listener) {
        this.complete(this.backingTree.addListener(path, listener));
    }

    @Override
    public void removeListener(DocumentTreeEventListener<V> listener) {
        this.complete(this.backingTree.removeListener(listener));
    }

    @Override
    public void addListener(DocumentTreeEventListener<V> listener) {
        this.complete(this.backingTree.addListener(listener));
    }

    @Override
    public AsyncAtomicDocumentTree<V> async() {
        return this.backingTree;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DocumentException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new DocumentException.Timeout(this.name());
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw new PrimitiveException(e.getCause());
        }
    }
}

